/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.configupdater;

import de.mhus.lib.core.MLog;
import de.mhus.lib.core.MSingleton;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.config.HashConfig;
import de.mhus.lib.core.config.IConfig;
import de.mhus.lib.core.config.XmlConfigFile;
import de.mhus.lib.core.directory.EmptyResourceNode;
import de.mhus.lib.core.directory.ResourceNode;
import de.mhus.lib.core.io.FileWatch;
import de.mhus.lib.core.logging.ConsoleFactory;
import de.mhus.lib.core.logging.LevelMapper;
import de.mhus.lib.core.logging.Log;
import de.mhus.lib.core.logging.LogFactory;
import de.mhus.lib.core.logging.MutableParameterMapper;
import de.mhus.lib.core.logging.ParameterEntryMapper;
import de.mhus.lib.core.logging.ParameterMapper;
import de.mhus.lib.core.system.ISingletonInternal;
import de.mhus.lib.core.system.SecureStreamToLogAdapter;
import de.mhus.lib.core.util.TimerIfc;
import java.io.File;
import java.io.PrintStream;

public class DefaultConfigLoader
extends MLog {
    private IConfig config;
    private FileWatch fileWatch;
    private boolean needFileWatch = false;
    private String configFile;
    private File baseDir;
    private ISingletonInternal internal;
    private static PrintStream stdOut = System.out;
    private static PrintStream stdErr = System.err;

    public void doInitialize(ISingletonInternal internal) {
        this.internal = internal;
        this.configFile = System.getProperty("mhus.lib.config.file");
        if (this.configFile == null) {
            this.configFile = "mhus-config.xml";
        }
        this.needFileWatch = true;
    }

    public void reConfigure() {
        LogFactory logFactory;
        block33: {
            String key;
            ResourceNode system;
            block32: {
                block31: {
                    block30: {
                        block29: {
                            block28: {
                                this.log().i("Load mhu-lib configuration");
                                system = this.getConfig().getNode("system");
                                if (system == null) {
                                    system = new EmptyResourceNode();
                                }
                                this.internal.getLogTrace().clear();
                                for (String p : system.getPropertyKeys()) {
                                    if (!p.startsWith("TRACE.")) continue;
                                    this.internal.getLogTrace().add(p.substring(6));
                                }
                                try {
                                    String key2 = "base.dir";
                                    String name = system.getString(key2);
                                    if (MString.isEmpty(name)) {
                                        name = System.getProperty("mhus.lib." + key2);
                                    }
                                    String baseDirName = ".";
                                    if (MString.isSet(name)) {
                                        baseDirName = name;
                                    }
                                    this.baseDir = new File(baseDirName);
                                }
                                catch (Throwable t) {
                                    if (!MSingleton.isDirtyTrace()) break block28;
                                    t.printStackTrace();
                                }
                            }
                            logFactory = null;
                            try {
                                key = "log.factory";
                                String name = system.getString(key);
                                if (MString.isEmpty(name)) {
                                    name = System.getProperty("mhus.lib." + key);
                                }
                                if (MString.isSet(name)) {
                                    logFactory = (LogFactory)Class.forName(name.trim()).newInstance();
                                }
                            }
                            catch (Throwable t) {
                                if (!MSingleton.isDirtyTrace()) break block29;
                                t.printStackTrace();
                            }
                        }
                        if (logFactory == null) {
                            logFactory = new ConsoleFactory();
                        }
                        try {
                            key = "level.mapper";
                            String name = system.getString(key);
                            if (MString.isEmpty(name)) {
                                name = System.getProperty("mhus.lib." + key);
                            }
                            if (MString.isSet(name)) {
                                logFactory.setLevelMapper((LevelMapper)Class.forName(name.trim()).newInstance());
                            }
                        }
                        catch (Throwable t) {
                            if (!MSingleton.isDirtyTrace()) break block30;
                            t.printStackTrace();
                        }
                    }
                    try {
                        key = "parameter.mapper";
                        String name = system.getString(key);
                        if (MString.isEmpty(name)) {
                            name = System.getProperty("mhus.lib." + key);
                        }
                        if (MString.isSet(name)) {
                            logFactory.setParameterMapper((ParameterMapper)Class.forName(name.trim()).newInstance());
                        }
                    }
                    catch (Throwable t) {
                        if (!MSingleton.isDirtyTrace()) break block31;
                        t.printStackTrace();
                    }
                }
                if (logFactory.getParameterMapper() != null && logFactory.getParameterMapper() instanceof MutableParameterMapper) {
                    try {
                        ResourceNode[] mappers = system.getNodes("parameter.mapper");
                        if (mappers.length > 0) {
                            ((MutableParameterMapper)((Object)logFactory.getParameterMapper())).clear();
                        }
                        for (ResourceNode mapper : mappers) {
                            String name = mapper.getString("name");
                            String clazz = mapper.getString("class");
                            if (!MString.isSet(name) || !MString.isSet(clazz)) continue;
                            ((MutableParameterMapper)((Object)logFactory.getParameterMapper())).put(name, (ParameterEntryMapper)Class.forName(clazz.trim()).newInstance());
                        }
                    }
                    catch (Throwable t) {
                        if (!MSingleton.isDirtyTrace()) break block32;
                        t.printStackTrace();
                    }
                }
            }
            try {
                key = "log.console.redirect";
                String name = system.getString(key);
                if (MString.isEmpty(name)) {
                    name = System.getProperty("mhus.lib." + key);
                }
                if (MString.isSet(name) && "true".equals(name)) {
                    System.setErr(new SecureStreamToLogAdapter(Log.LEVEL.ERROR, stdErr));
                    System.setOut(new SecureStreamToLogAdapter(Log.LEVEL.INFO, stdOut));
                }
            }
            catch (Throwable t) {
                if (!MSingleton.isDirtyTrace()) break block33;
                t.printStackTrace();
            }
        }
        this.internal.setLogFactory(logFactory);
        MSingleton.updateLoggers();
        MSingleton.getConfigUpdater().doUpdate();
    }

    private boolean internalLoadConfig(File file) {
        block4: {
            if (file.exists() && file.isFile()) {
                try {
                    XmlConfigFile c = new XmlConfigFile(file);
                    this.config = c;
                    return true;
                }
                catch (Exception e) {
                    if (!MSingleton.isDirtyTrace()) break block4;
                    e.printStackTrace();
                }
            }
        }
        if (MSingleton.isDirtyTrace()) {
            System.out.println("*** MHUS Config file not found" + file);
        }
        return false;
    }

    public synchronized IConfig getConfig() {
        if (this.config == null) {
            this.config = new HashConfig();
            if (this.fileWatch != null) {
                this.fileWatch.doStop();
                this.fileWatch = null;
            }
            File f = new File(this.baseDir, this.configFile);
            if (MSingleton.isDirtyTrace()) {
                System.out.println("--- Try to load mhus config from " + f.getAbsolutePath());
            }
            if (!this.internalLoadConfig(f)) {
                return this.config;
            }
            if (this.needFileWatch) {
                TimerIfc timer = MSingleton.get().getBaseControl().getCurrentBase().lookup(TimerIfc.class);
                this.fileWatch = new FileWatch(f, timer, new FileWatch.Listener(){

                    @Override
                    public void onFileChanged(FileWatch fileWatch) {
                        File file = fileWatch.getFile();
                        if (DefaultConfigLoader.this.internalLoadConfig(file)) {
                            DefaultConfigLoader.this.reConfigure();
                        }
                    }

                    @Override
                    public void onFileWatchError(FileWatch fileWatch, Throwable t) {
                        if (MSingleton.isDirtyTrace()) {
                            t.printStackTrace();
                        }
                    }
                }).doStart();
            }
        }
        return this.config;
    }
}

