package de.mhus.lib.core.cast;

import de.mhus.lib.core.logging.Log;
import de.mhus.lib.core.util.ObjectContainer;

/**
 * <p>ObjectToShort class.</p>
 *
 * @author mikehummel
 * @version $Id: $Id
 */
public class ObjectToShort implements Caster<Object,Short> {

	private final static Log log = Log.getLog(ObjectToShort.class);
	
	/** {@inheritDoc} */
	@Override
	public Class<? extends Short> getToClass() {
		return Short.class;
	}

	/** {@inheritDoc} */
	@Override
	public Class<? extends Object> getFromClass() {
		return Object.class;
	}

	/** {@inheritDoc} */
	@Override
	public Short cast(Object in, Short def) {
		ObjectContainer<Short> ret = new ObjectContainer<>(def);
		toShort(in, (short) 0, ret);
		return ret.getObject();
	}

	/**
	 * <p>toShort.</p>
	 *
	 * @param in a {@link java.lang.Object} object.
	 * @param def a short.
	 * @param ret a {@link de.mhus.lib.core.util.ObjectContainer} object.
	 * @return a short.
	 */
	public short toShort(Object in, short def, ObjectContainer<Short> ret) {
		if (in == null) return def;
		if (in instanceof Short) {
			if (ret != null) ret.setObject((Short)in);
			return ((Short)in).shortValue();
		}
		if (in instanceof Number) {
			short r = ((Number)in).shortValue();
			if (ret != null) ret.setObject(r);
			return r;
		}

		String _in = String.valueOf(in);
		try {
			if (_in.startsWith("0x") || _in.startsWith("-0x") || _in.startsWith("+0x")) {
				int start = 2;
				if (_in.startsWith("-")) start = 3;
				int out = 0;
				for (int i = start; i < _in.length(); i++) {
					int s = -1;
					char c = _in.charAt(i);
					if (c >= '0' && c <= '9')
						s = c - '0';
					else if (c >= 'a' && c <= 'f')
						s = c - 'a' + 10;
					else if (c >= 'A' && c <= 'F')
						s = c - 'A' + 10;

					if (s == -1)
						throw new NumberFormatException(_in);
					

					out = out * (short)16 + (short)s;
				}
				if (_in.startsWith("-")) out = -out;
				if (out > Short.MAX_VALUE) out = Short.MAX_VALUE;
				if (out < Short.MIN_VALUE) out = Short.MIN_VALUE;
				if (ret != null) ret.setObject((short)out);
				return (short)out;
			}
			
			short r = Short.parseShort(_in);
			if (ret != null) ret.setObject(r);
			return r;
		} catch (Throwable e) {
			log.t(_in, e.toString());
			return def;
		}
	}
}
