/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.pojo;

import de.mhus.lib.core.lang.MObject;
import de.mhus.lib.core.pojo.FunctionAction;
import de.mhus.lib.core.pojo.FunctionAttribute;
import de.mhus.lib.core.pojo.MethodAnalyser;
import de.mhus.lib.core.pojo.PojoModelImpl;
import de.mhus.lib.core.pojo.PojoParser;
import de.mhus.lib.core.pojo.PojoStrategy;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.Set;

public class FunctionsOnlyStrategy
extends MObject
implements PojoStrategy {
    private boolean toLower = true;
    private Class<? extends Annotation>[] annotationMarker;

    public FunctionsOnlyStrategy() {
        this(true, null);
    }

    public FunctionsOnlyStrategy(boolean toLower, Class<? extends Annotation> ... annotationMarker) {
        this.toLower = toLower;
        this.annotationMarker = annotationMarker;
    }

    @Override
    public void parse(PojoParser parser, Class<?> clazz, PojoModelImpl model) {
        this.parse("", null, parser, clazz, model, 0);
    }

    protected void parse(String prefix, FunctionAttribute<Object> parent, PojoParser parser, Class<?> clazz, PojoModelImpl model, int level) {
        if (level > 10) {
            return;
        }
        for (Method m : this.getMethods(clazz)) {
            if (Modifier.isStatic(m.getModifiers())) continue;
            try {
                String mName = m.getName();
                String s = this.toLower ? mName.toLowerCase() : mName;
                String name = prefix + s;
                if (!this.isMarker(clazz, m)) continue;
                FunctionAction action = new FunctionAction(clazz, m, name, parent);
                model.addAction(action);
            }
            catch (Exception e) {
                this.log().d(e);
            }
        }
    }

    private boolean isMarker(Class<?> clazz, Method m) {
        if (this.annotationMarker == null || this.annotationMarker.length == 0) {
            return true;
        }
        if (m != null) {
            for (Class<? extends Annotation> a : this.annotationMarker) {
                if (!m.isAnnotationPresent(a)) continue;
                return true;
            }
            Set<Method> res = MethodAnalyser.getMethodsForMethod(clazz, m.getName());
            for (Method m2 : res) {
                for (Class<? extends Annotation> a : this.annotationMarker) {
                    if (!m2.isAnnotationPresent(a)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected LinkedList<Method> getMethods(Class<?> clazz) {
        LinkedList<Method> out = new LinkedList<Method>();
        do {
            for (Method m : clazz.getMethods()) {
                out.add(m);
            }
        } while ((clazz = clazz.getSuperclass()) != null);
        return out;
    }

    @Override
    public void parseObject(PojoParser parser, Object pojo, PojoModelImpl model) {
        Class<?> clazz = pojo.getClass();
        this.parse(parser, clazz, model);
    }
}

