/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.logging;

import de.mhus.lib.annotations.activator.DefaultImplementation;
import de.mhus.lib.core.MSingleton;
import de.mhus.lib.core.directory.ResourceNode;
import de.mhus.lib.core.lang.IBase;
import de.mhus.lib.core.logging.ConsoleFactory;
import de.mhus.lib.core.logging.Log;
import de.mhus.lib.core.service.ConfigProvider;
import java.util.WeakHashMap;

@DefaultImplementation(value=ConsoleFactory.class)
public abstract class LogFactory
implements IBase {
    WeakHashMap<String, Log> buffer = new WeakHashMap();
    protected Log.LEVEL level = Log.LEVEL.INFO;

    public Log getInstance(Class<?> clazz) {
        return this.getInstance(clazz.getCanonicalName());
    }

    public abstract void init(ResourceNode var1) throws Exception;

    public void init() throws Exception {
        ResourceNode config = MSingleton.get().getBaseControl().base(this).base(ConfigProvider.class).getConfig(this, null);
        this.init(config);
    }

    public synchronized Log getInstance(String name) {
        Log inst = this.buffer.get(name);
        if (inst == null) {
            inst = this.createInstance(name);
            this.buffer.put(name, inst);
        }
        return inst;
    }

    public abstract Log createInstance(String var1);

    public Log getLog(Class<?> class1) {
        return this.getInstance(class1);
    }

    public void setDefaultLevel(Log.LEVEL level) {
        this.level = level;
    }

    public Log.LEVEL getDefaultLevel() {
        return this.level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLoggers() {
        WeakHashMap<String, Log> weakHashMap = this.buffer;
        synchronized (weakHashMap) {
            for (Log log : this.buffer.values()) {
                log.update();
            }
        }
    }
}

