/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.lang;

import de.mhus.lib.annotations.pojo.Hidden;
import de.mhus.lib.core.MLog;
import de.mhus.lib.core.MSingleton;
import de.mhus.lib.core.MSystem;
import de.mhus.lib.core.lang.Base;
import de.mhus.lib.core.lang.BaseControl;

public class MObject
extends MLog {
    @Hidden
    private Base base;
    @Hidden
    private Base originalBase;
    @Hidden
    private Base oldBase;

    public MObject() {
        this.initBase();
    }

    private synchronized MObject initBase() {
        if (this.base == null || this.base.isDestroyed()) {
            BaseControl control = MSingleton.get().getBaseControl();
            this.base = control.base(this);
            control.inject(this, this.base);
        }
        return this;
    }

    protected <T> T base(Class<T> ifc) {
        try {
            return this.base.base(ifc);
        }
        catch (Exception e) {
            if (MSingleton.isDirtyTrace()) {
                e.printStackTrace();
            }
            return null;
        }
    }

    protected boolean isBase(Class<?> ifc) {
        try {
            return this.base.isBase(ifc);
        }
        catch (Exception e) {
            if (MSingleton.isDirtyTrace()) {
                e.printStackTrace();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forkBase() {
        MObject mObject = this;
        synchronized (mObject) {
            if (this.originalBase != null) {
                return;
            }
            this.base = MSingleton.get().getBaseControl().createBase(this, this.base);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createBase() {
        MObject mObject = this;
        synchronized (mObject) {
            if (this.originalBase != null) {
                return;
            }
            this.originalBase = this.base;
            this.base = MSingleton.get().getBaseControl().createBase(this, this.base);
            MSingleton.get().getBaseControl().installBase(this.base);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void installBase() {
        MObject mObject = this;
        synchronized (mObject) {
            this.oldBase = MSingleton.get().getBaseControl().installBase(this.base);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void leaveBase() {
        MObject mObject = this;
        synchronized (mObject) {
            if (this.oldBase != null) {
                MSingleton.get().getBaseControl().installBase(this.oldBase);
                this.oldBase = null;
                return;
            }
            if (this.originalBase == null) {
                return;
            }
            this.base = this.originalBase;
            MSingleton.get().getBaseControl().installBase(this.base);
            this.originalBase = null;
        }
    }

    protected Base base() {
        return this.base;
    }

    public String toString() {
        return MSystem.toString(this, new Object[0]);
    }
}

