/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.directory.fs;

import de.mhus.lib.core.directory.ResourceNode;
import de.mhus.lib.core.directory.fs.FileResourceRoot;
import de.mhus.lib.errors.MException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;

public class FileResource
extends ResourceNode {
    public static final long UNKNOWN_LENGTH = -1L;
    private FileResourceRoot root;
    private File file;
    private FileResource parent;
    private HashMap<String, FileResource> cache = new HashMap();

    public FileResource(FileResourceRoot root, FileResource parent, File file) {
        if (root == null) {
            root = (FileResourceRoot)this;
        }
        this.root = root;
        this.file = file;
        this.parent = parent;
    }

    @Override
    public String[] getPropertyKeys() {
        KEYS[] v = KEYS.values();
        String[] out = new String[v.length];
        for (int i = 0; i < v.length; ++i) {
            out[i] = v[i].name().toLowerCase();
        }
        return out;
    }

    @Override
    public ResourceNode getNode(String key) {
        File f;
        if (key == null) {
            return null;
        }
        if (key.equals("..") || key.equals(".")) {
            return null;
        }
        if (key.indexOf(47) > -1 || key.indexOf(92) > -1) {
            return null;
        }
        FileResource cached = this.cache.get(key);
        if (cached != null) {
            if (cached.isValide()) {
                return cached;
            }
            this.cache.remove(key);
        }
        if (!(f = new File(this.file, key)).exists()) {
            return null;
        }
        cached = new FileResource(this.root, this, f);
        this.cache.put(key, cached);
        return cached;
    }

    @Override
    public ResourceNode[] getNodes() {
        LinkedList<ResourceNode> out = new LinkedList<ResourceNode>();
        for (String sub : this.file.list()) {
            ResourceNode n = this.getNode(sub);
            if (n == null) continue;
            out.add(n);
        }
        return out.toArray(new ResourceNode[out.size()]);
    }

    @Override
    public ResourceNode[] getNodes(String key) {
        ResourceNode n = this.getNode(key);
        if (n == null) {
            return new ResourceNode[0];
        }
        return new ResourceNode[]{n};
    }

    @Override
    public String[] getNodeKeys() {
        LinkedList<String> out = new LinkedList<String>();
        for (String sub : this.file.list()) {
            ResourceNode n = this.getNode(sub);
            if (n == null) continue;
            out.add(sub);
        }
        return out.toArray(new String[out.size()]);
    }

    @Override
    public String getName() throws MException {
        return this.file.getName();
    }

    @Override
    public InputStream getInputStream(String key) {
        if (this.file.isDirectory()) {
            return null;
        }
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public ResourceNode getParent() {
        return this.parent;
    }

    @Override
    public URL getUrl() {
        try {
            return this.file.toURL();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Object getProperty(String name) {
        if (name.equals("file")) {
            return this.file;
        }
        if (name.equals("filepath")) {
            return this.file.getAbsolutePath();
        }
        try {
            KEYS key = KEYS.valueOf(name.toUpperCase());
            switch (key) {
                case NAME: {
                    return this.file.getName();
                }
                case LENGTH: {
                    return this.file.length();
                }
                case MODIFIED: {
                    if (this.file.isFile()) {
                        return this.file.lastModified();
                    }
                    return -1L;
                }
                case TYPE: {
                    if (this.file.isFile()) {
                        return TYPE.FILE;
                    }
                    if (this.file.isDirectory()) {
                        return TYPE.DIRCTORY;
                    }
                    return TYPE.UNKNOWN;
                }
                case HIDDEN: {
                    return this.file.isHidden();
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public boolean isProperty(String name) {
        try {
            KEYS key = KEYS.valueOf(name.toUpperCase());
            return key != null;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    @Override
    public void removeProperty(String key) {
    }

    @Override
    public void setProperty(String key, Object value) {
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    @Override
    public boolean isValide() {
        return this.file != null && this.file.exists();
    }

    @Override
    public boolean hasContent() {
        return this.file.isFile();
    }

    public static enum TYPE {
        FILE,
        DIRCTORY,
        UNKNOWN;

    }

    public static enum KEYS {
        NAME,
        LENGTH,
        MODIFIED,
        TYPE,
        HIDDEN;

    }
}

