/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core;

import de.mhus.lib.core.IProperties;
import de.mhus.lib.core.MSystem;
import de.mhus.lib.core.util.SetCast;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class MProperties
extends IProperties
implements Externalizable {
    protected Properties properties = null;

    public MProperties() {
        this(new Properties());
    }

    public MProperties(String ... values) {
        this(new Properties());
        if (values != null) {
            for (int i = 0; i < values.length; i += 2) {
                if (i + 1 >= values.length) continue;
                this.setString(values[i], values[i + 1]);
            }
        }
    }

    public MProperties(Dictionary<String, ?> config) {
        this.properties = new Properties();
        Enumeration<String> enu = config.keys();
        while (enu.hasMoreElements()) {
            String next = enu.nextElement();
            this.properties.put(next, config.get(next));
        }
    }

    public MProperties(Map<String, Object> in) {
        this.properties = new Properties();
        this.properties.putAll(in);
    }

    public MProperties(Properties properties) {
        this.properties = properties;
    }

    @Override
    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    public boolean isProperty(String name) {
        return this.properties.containsKey(name);
    }

    @Override
    public void removeProperty(String key) {
        this.properties.remove(key);
    }

    @Override
    public void setProperty(String key, Object value) {
        if (value == null) {
            this.properties.remove(key);
        } else {
            this.properties.put(key, value);
        }
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public Set<String> keys() {
        return new SetCast(this.properties.keySet());
    }

    @Override
    public String toString() {
        return MSystem.toString(this, this.properties);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.properties);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.properties = (Properties)in.readObject();
    }

    public static MProperties explodeToMProperties(String[] properties) {
        MProperties p = new MProperties();
        if (properties != null) {
            for (String i : properties) {
                int idx;
                if (i == null || (idx = i.indexOf(61)) < 0) continue;
                p.setProperty(i.substring(0, idx).trim(), i.substring(idx + 1));
            }
        }
        return p;
    }

    public static Properties explodeToProperties(String[] properties) {
        Properties p = new Properties();
        if (properties != null) {
            for (String i : properties) {
                int idx;
                if (i == null || (idx = i.indexOf(61)) < 0) continue;
                p.setProperty(i.substring(0, idx).trim(), i.substring(idx + 1));
            }
        }
        return p;
    }
}

