/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core;

import de.mhus.lib.core.MCast;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.json.TransformHelper;
import de.mhus.lib.core.pojo.PojoAttribute;
import de.mhus.lib.core.pojo.PojoModel;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;

public class MJson {
    private static ObjectMapper mapper = new ObjectMapper();
    private static JsonFactory factory = new JsonFactory();

    public static void save(JsonNode json, Writer w) throws JsonGenerationException, JsonMappingException, IOException {
        mapper.writeValue(w, (Object)json);
    }

    public static void save(JsonNode json, OutputStream w) throws JsonGenerationException, JsonMappingException, IOException {
        mapper.writeValue(w, (Object)json);
    }

    public static JsonNode load(InputStream r) throws JsonProcessingException, IOException {
        JsonParser parser = factory.createJsonParser(r);
        JsonNode in = mapper.readTree(parser);
        return in;
    }

    public static JsonNode load(Reader r) throws JsonProcessingException, IOException {
        JsonParser parser = factory.createJsonParser(r);
        JsonNode in = mapper.readTree(parser);
        return in;
    }

    public static void write(Object value, OutputStream out) throws JsonGenerationException, JsonMappingException, IOException {
        mapper.writeValue(out, value);
    }

    public static void write(Object value, Writer out) throws JsonGenerationException, JsonMappingException, IOException {
        mapper.writeValue(out, value);
    }

    public static <T> T read(InputStream r, Class<T> type) throws JsonParseException, JsonMappingException, IOException {
        return (T)mapper.readValue(r, type);
    }

    public static <T> T read(Reader r, Class<T> type) throws JsonParseException, JsonMappingException, IOException {
        return (T)mapper.readValue(r, type);
    }

    public static <T> T read(Reader r, T def) {
        try {
            return (T)mapper.readValue(r, def.getClass());
        }
        catch (Exception e) {
            return def;
        }
    }

    public static <T> T read(InputStream r, T def) {
        try {
            return (T)mapper.readValue(r, def.getClass());
        }
        catch (Exception e) {
            return def;
        }
    }

    public static JsonNode getByPath(JsonNode parent, String path) {
        if (path == null || parent == null) {
            return null;
        }
        JsonNode cur = parent;
        for (String part : path.split("/")) {
            if (MString.isSet(part)) {
                cur = cur.get(part);
            }
            if (cur != null) continue;
            return null;
        }
        return cur;
    }

    public static <T> T getValue(JsonNode parent, String path, T def) {
        Object out = MJson.getValue(parent, path);
        if (out == null) {
            return def;
        }
        return (T)MCast.toType(out, def.getClass(), def);
    }

    public static Object getValue(JsonNode parent, String path) {
        JsonNode node = MJson.getByPath(parent, path);
        return MJson.getValue(node);
    }

    public static Object getValue(JsonNode node) {
        if (node == null) {
            return null;
        }
        return MJson.getValue(node, (TransformHelper)null);
    }

    public static Object getValue(JsonNode node, TransformHelper helper) {
        Object out = null;
        if (node == null) {
            return null;
        }
        try {
            if (node.isTextual()) {
                out = node.getValueAsText();
            } else if (node.isNull()) {
                out = null;
            } else if (node.isBigDecimal()) {
                out = node.getDecimalValue();
            } else if (node.isBigInteger()) {
                out = node.getBigIntegerValue();
            } else if (node.isBinary()) {
                out = node.getBinaryValue();
            } else if (node.isBoolean()) {
                out = node.getBooleanValue();
            } else if (node.isDouble()) {
                out = node.getDoubleValue();
            } else if (node.isInt()) {
                out = node.getIntValue();
            } else if (node.isLong()) {
                out = node.getLongValue();
            } else if (node.isNumber()) {
                out = node.getNumberValue();
            } else if (node.isObject() && helper == null) {
                helper = new TransformHelper();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out;
    }

    public static String getText(JsonNode parent, String path, String def) {
        JsonNode node = MJson.getByPath(parent, path);
        if (node == null) {
            return def;
        }
        String out = null;
        out = node.getTextValue();
        if (out == null) {
            out = def;
        }
        return out;
    }

    public static void pojoToJson(Object from, ObjectNode to) throws IOException {
        MJson.pojoToJson(from, to, null);
    }

    public static void pojoToJson(Object from, ObjectNode to, TransformHelper helper) throws IOException {
        if (from == null) {
            return;
        }
        if (helper == null) {
            helper = new TransformHelper();
        }
        if (from instanceof Object[]) {
            ArrayNode array = to.arrayNode();
            to.put("array", (JsonNode)array);
            for (Object i : (Object[])from) {
                ObjectNode o = array.addObject();
                MJson.pojoToJson(i, o, helper.incLevel());
            }
            helper.decLevel();
            return;
        }
        PojoModel model = helper.createPojoModel(from);
        for (PojoAttribute attr : model) {
            try {
                Object obj;
                ArrayNode array;
                Object value = attr.get(from);
                String name = attr.getName();
                if (value == null) {
                    to.put(name, (String)null);
                    continue;
                }
                if (value instanceof Boolean) {
                    to.put(name, ((Boolean)value).booleanValue());
                    continue;
                }
                if (value instanceof Integer) {
                    to.put(name, ((Integer)value).intValue());
                    continue;
                }
                if (value instanceof String) {
                    to.put(name, (String)value);
                    continue;
                }
                if (value.getClass().isEnum()) {
                    to.put(name, ((Enum)value).ordinal());
                    to.put(name + "_", ((Enum)value).name());
                    continue;
                }
                if (value instanceof Date) {
                    to.put(name, ((Date)value).getTime());
                    continue;
                }
                if (value instanceof String[]) {
                    array = to.arrayNode();
                    to.put(name, (JsonNode)array);
                    for (String string : (String[])value) {
                        array.add(string);
                    }
                    continue;
                }
                if (value instanceof Object[]) {
                    array = to.arrayNode();
                    to.put(name, (JsonNode)array);
                    for (Object object : (Object[])value) {
                        ObjectNode o = array.addObject();
                        MJson.pojoToJson(object, o, helper.incLevel());
                    }
                    continue;
                }
                if (value instanceof Map) {
                    obj = to.objectNode();
                    to.put(name, (JsonNode)obj);
                    for (Map.Entry e : ((Map)value).entrySet()) {
                        obj.put(String.valueOf(e.getKey()), String.valueOf(e.getValue()));
                    }
                    continue;
                }
                if (value instanceof Collection) {
                    obj = (Collection)value;
                    ArrayNode array2 = to.arrayNode();
                    to.put(name, (JsonNode)array2);
                    Iterator i$ = obj.iterator();
                    while (i$.hasNext()) {
                        Object o = i$.next();
                        ObjectNode objectNode = array2.objectNode();
                        MJson.pojoToJson(o, objectNode, helper.incLevel());
                        array2.add((JsonNode)objectNode);
                    }
                    continue;
                }
                if (value instanceof Class) {
                    to.put(attr.getName(), ((Class)value).getSimpleName());
                    continue;
                }
                if (value instanceof UUID) {
                    to.put(attr.getName(), String.valueOf(value));
                    continue;
                }
                if (!helper.checkLevel()) {
                    helper.log("too deep:" + attr.getName() + " " + value.getClass().getSimpleName());
                    return;
                }
                ObjectNode sub = to.objectNode();
                MJson.pojoToJson(value, sub, helper.incLevel());
                to.put(attr.getName(), (JsonNode)sub);
            }
            catch (Throwable t) {
                helper.log(null, t);
            }
        }
        helper.postToJson(from, to);
    }

    public static void propertiesToPojo(Map<String, String> from, Object to, TransformHelper helper) throws IOException {
        PojoModel model = helper.createPojoModel(from);
        for (PojoAttribute attr : model) {
            String name = attr.getName();
            String value = from.get(name);
            if (value == null) continue;
            attr.set(to, value);
        }
    }

    public static Object jsonToPojo(JsonNode from, Object to) throws IOException, IllegalAccessException {
        return MJson.jsonToPojo(from, to, null);
    }

    public static Object jsonToPojo(JsonNode from, Object to, TransformHelper helper) throws IOException, IllegalAccessException {
        if (helper == null) {
            helper = new TransformHelper();
        }
        if (to == null) {
            to = helper.createObject(from);
        }
        if (to == null) {
            return null;
        }
        PojoModel model = helper.createPojoModel(to);
        for (PojoAttribute attr : model) {
            String name = attr.getName();
            Class<?> type = attr.getType();
            JsonNode json = from.get(helper.getPrefix() + name);
            try {
                LinkedList<Object> l;
                if (json == null || !attr.canWrite()) continue;
                if (type == Boolean.class || type == Boolean.TYPE) {
                    attr.set(to, json.getValueAsBoolean(false));
                    continue;
                }
                if (type == Integer.class || type == Integer.TYPE) {
                    attr.set(to, json.getValueAsInt(0));
                    continue;
                }
                if (type == String.class) {
                    attr.set(to, json.getValueAsText());
                    continue;
                }
                if (type == UUID.class) {
                    try {
                        attr.set(to, UUID.fromString(json.getValueAsText()));
                    }
                    catch (IllegalArgumentException e) {
                        attr.set(to, null);
                    }
                    continue;
                }
                if (type.isEnum()) {
                    Object c;
                    ?[] cons = type.getEnumConstants();
                    int ord = json.getValueAsInt(0);
                    Object t = c = cons.length > 0 ? (Object)cons[0] : null;
                    if (ord >= 0 && ord < cons.length) {
                        c = cons[ord];
                    }
                    attr.set(to, c);
                    continue;
                }
                if (type == Date.class) {
                    try {
                        attr.set(to, new Date(json.getValueAsLong(0L)));
                    }
                    catch (IllegalArgumentException e) {
                        attr.set(to, null);
                    }
                    continue;
                }
                if (Map.class.isAssignableFrom(type)) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    Iterator iter = json.getFieldNames();
                    while (iter.hasNext()) {
                        String n = (String)iter.next();
                        map.put(n, MJson.getValue(json.get(name), helper));
                    }
                    attr.set(to, map);
                    continue;
                }
                if (Collection.class.isAssignableFrom(type) && json instanceof ArrayNode) {
                    LinkedList<Object> list = new LinkedList<Object>();
                    ArrayNode array = (ArrayNode)json;
                    for (JsonNode a : array) {
                        list.add(MJson.getValue(a, helper));
                    }
                    continue;
                }
                if (type == String[].class) {
                    try {
                        l = new LinkedList<Object>();
                        for (JsonNode i : json) {
                            l.add(i.getValueAsText());
                        }
                        attr.set(to, l.toArray(new String[l.size()]));
                    }
                    catch (IllegalArgumentException e) {
                        attr.set(to, null);
                    }
                    continue;
                }
                if (type.isArray()) {
                    try {
                        l = new LinkedList();
                        for (JsonNode i : json) {
                            Object obj = helper.createObject(type);
                            if (obj == null) continue;
                            MJson.jsonToPojo(i, obj, helper);
                            l.add(obj);
                        }
                        attr.set(to, l.toArray((Object[])Array.newInstance(type, l.size())));
                    }
                    catch (IllegalArgumentException e) {
                        attr.set(to, null);
                    }
                    continue;
                }
                Object obj = helper.createObject(type);
                if (obj != null) {
                    MJson.jsonToPojo(json, obj, helper);
                }
                attr.set(to, obj);
            }
            catch (Throwable t) {
                helper.log("ERROR " + name, t);
            }
        }
        return to;
    }

    public static ObjectNode createObjectNode() {
        return mapper.createObjectNode();
    }
}

