/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core;

import de.mhus.lib.core.cast.Caster;
import de.mhus.lib.core.cast.DoubleToString;
import de.mhus.lib.core.cast.FloatToString;
import de.mhus.lib.core.cast.ObjectToBoolean;
import de.mhus.lib.core.cast.ObjectToByte;
import de.mhus.lib.core.cast.ObjectToCalendar;
import de.mhus.lib.core.cast.ObjectToDate;
import de.mhus.lib.core.cast.ObjectToDouble;
import de.mhus.lib.core.cast.ObjectToFloat;
import de.mhus.lib.core.cast.ObjectToInteger;
import de.mhus.lib.core.cast.ObjectToLong;
import de.mhus.lib.core.cast.ObjectToShort;
import de.mhus.lib.core.cast.ObjectToSqlDate;
import de.mhus.lib.core.cast.ObjectToString;
import de.mhus.lib.core.cast.ObjectToUUID;
import de.mhus.lib.core.logging.Log;
import de.mhus.lib.core.util.VectorMap;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Date;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public final class MCast {
    private static Log log = Log.getLog(MCast.class);
    private static final char[] HEX_CHAR_TABLE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static VectorMap<Class<?>, Class<?>, Caster<?, ?>> casters = new VectorMap();
    private static final ObjectToBoolean OBJECT_TO_BOOLEAN = new ObjectToBoolean();
    private static final ObjectToInteger OBJECT_TO_INTEGER = new ObjectToInteger();
    private static final ObjectToByte OBJECT_TO_BYTE = new ObjectToByte();
    private static final ObjectToShort OBJECT_TO_SHORT = new ObjectToShort();
    private static final ObjectToLong OBJECT_TO_LONG = new ObjectToLong();
    private static final ObjectToDouble OBJECT_TO_DOUBLE = new ObjectToDouble();
    private static final ObjectToFloat OBJECT_TO_FLOAT = new ObjectToFloat();
    private static final ObjectToCalendar OBJECT_TO_CALENDAR = new ObjectToCalendar();
    private static final ObjectToDate OBJECT_TO_DATE = new ObjectToDate();
    private static final ObjectToSqlDate OBJECT_TO_SQLDATE = new ObjectToSqlDate();
    private static final DoubleToString DOUBLE_TO_STRING = new DoubleToString();
    private static final FloatToString FLOAT_TO_STRING = new FloatToString();
    private static final ObjectToString OBJECT_TO_STRING = new ObjectToString();

    public static String toCurrencyString(double _in) {
        _in = (double)Math.round(_in * 100.0) / 100.0;
        StringBuffer out = new StringBuffer();
        out.append(_in);
        int pos = out.indexOf(".");
        if (pos >= 0) {
            out.setCharAt(pos, ',');
        } else {
            pos = out.indexOf(",");
        }
        if (pos <= 0) {
            out.append(",00");
        } else if (out.length() - pos <= 2) {
            out.append("0");
        }
        return out.toString();
    }

    public static void addCaster(Caster<?, ?> caster, boolean overwrite) {
        if (!overwrite && casters.containsKey(caster.getFromClass(), caster.getToClass())) {
            return;
        }
        casters.put(caster.getFromClass(), caster.getToClass(), caster);
    }

    public static java.util.Date toDate(Object in, java.util.Date def) {
        return OBJECT_TO_DATE.cast(in, def);
    }

    public static Calendar toCalendar(Object in) {
        return OBJECT_TO_CALENDAR.cast(in, null);
    }

    public static Calendar toCalendar(java.util.Date _in, TimeZone tz, Locale l) {
        Calendar calendar = Calendar.getInstance(tz, l);
        calendar.setTime(_in);
        return calendar;
    }

    public static Calendar toCalendar(String in) {
        return OBJECT_TO_CALENDAR.cast((Object)in, null);
    }

    public static Calendar toCalendar(String in, Calendar def) {
        return OBJECT_TO_CALENDAR.cast((Object)in, def);
    }

    public static String toBinaryString(byte[] in) {
        char[] hex = new char[2 * in.length];
        int index = 0;
        for (byte b : in) {
            int v = b & 0xFF;
            hex[index++] = HEX_CHAR_TABLE[v >>> 4];
            hex[index++] = HEX_CHAR_TABLE[v & 0xF];
        }
        return new String(hex);
    }

    public static byte[] fromBinaryString(String in) {
        byte[] out = new byte[in.length() / 2];
        for (int i = 0; i < out.length; ++i) {
            out[i] = MCast.byteFromHex(in, i * 2);
        }
        return out;
    }

    public static byte byteFromHex(String in, int offset) {
        int i = Integer.parseInt(in.substring(offset, offset + 2), 16);
        byte b = (byte)(i & 0xFF);
        return b;
    }

    public static String toHex2String(byte in) {
        char[] hex = new char[2];
        int v = in & 0xFF;
        hex[0] = HEX_CHAR_TABLE[v >>> 4];
        hex[1] = HEX_CHAR_TABLE[v & 0xF];
        return new String(hex);
    }

    public static boolean toboolean(Object _in, boolean _default) {
        return OBJECT_TO_BOOLEAN.toBoolean(_in, _default, null);
    }

    public static float tofloat(Object in, float def) {
        return OBJECT_TO_FLOAT.toFloat(in, def, null);
    }

    public static double todouble(Object in, double def) {
        return OBJECT_TO_DOUBLE.toDouble(in, def, null);
    }

    public static int toint(Object in, int def) {
        return OBJECT_TO_INTEGER.toInt(in, def, null);
    }

    public static long tolong(Object in, long def) {
        return OBJECT_TO_LONG.toLong(in, def, null);
    }

    public static byte tobyte(Object in, byte def) {
        return OBJECT_TO_BYTE.toByte(in, def, null);
    }

    public static short toshort(Object in, short def) {
        return OBJECT_TO_SHORT.toShort(in, def, null);
    }

    public static String toString(double in) {
        return DOUBLE_TO_STRING.toString(in);
    }

    public static String toString(float in) {
        return FLOAT_TO_STRING.toString(in);
    }

    public static String toString(boolean _in) {
        if (_in) {
            return "true";
        }
        return "false";
    }

    public static String toString(int _in) {
        return Integer.toString(_in);
    }

    public static String toString(int _in, int _digits) {
        String out = Integer.toString(_in);
        while (out.length() < _digits) {
            out = "0" + out;
        }
        return out;
    }

    public static String toString(long _in) {
        return String.valueOf(_in);
    }

    public static String toHex2String(int _in) {
        String out = Integer.toHexString(_in).toUpperCase();
        if (out.length() == 1) {
            out = "0" + out;
        }
        return out;
    }

    public static String toHex4String(int _in) {
        return MCast.toHex2String(_in / 256) + MCast.toHex2String(_in % 256);
    }

    public static String[] toStringArray(List<?> _v) {
        String[] out = new String[_v.size()];
        for (int i = 0; i < _v.size(); ++i) {
            Object o = _v.get(i);
            out[i] = o == null ? null : o.toString();
        }
        return out;
    }

    public static int tointFromHex(String _in) {
        int out = 0;
        for (int i = 0; i < _in.length(); ++i) {
            int x = 0;
            char c = _in.charAt(i);
            if (c >= '0' && c <= '9') {
                x = c - 48;
            } else if (c >= 'a' && c <= 'f') {
                x = c - 97 + 10;
            } else if (c >= 'A' && c <= 'F') {
                x = c - 65 + 10;
            } else {
                throw new NumberFormatException(_in);
            }
            out = out * 16 + x;
        }
        return out;
    }

    public static String toString(byte[] in) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < in.length; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(Byte.toString(in[i]));
        }
        return sb.toString();
    }

    public static byte[] toByteArray(String in) {
        if (in.length() == 0) {
            return new byte[0];
        }
        int offset = 0;
        int cnt = 0;
        while ((offset = in.indexOf(44, offset + 1)) >= 0) {
            ++cnt;
        }
        offset = 0;
        int old = 0;
        byte[] out = new byte[cnt + 1];
        cnt = 0;
        while ((offset = in.indexOf(44, offset + 1)) >= 0) {
            out[cnt] = Byte.parseByte(in.substring(old, offset));
            ++cnt;
            old = offset + 1;
        }
        out[cnt] = Byte.parseByte(in.substring(old));
        return out;
    }

    public static String toString(String firstLine, StackTraceElement[] trace) {
        StringBuffer sb = new StringBuffer();
        if (firstLine != null) {
            sb.append(firstLine).append('\n');
        }
        if (trace == null) {
            return sb.toString();
        }
        for (int i = 0; i < trace.length; ++i) {
            sb.append("\tat ").append(trace[i].getClassName()).append('.').append(trace[i].getMethodName()).append('(').append(trace[i].getFileName()).append(':').append(trace[i].getLineNumber()).append(")\n");
        }
        return sb.toString();
    }

    public static Map<String, Object> toIndexedMap(Object ... values) {
        HashMap<String, Object> out = new HashMap<String, Object>();
        for (int i = 0; i < values.length; ++i) {
            out.put(MCast.toString(i), values[i]);
        }
        return out;
    }

    public static String objectToString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return MCast.toString((Integer)value);
        }
        if (value instanceof Long) {
            return MCast.toString((Long)value);
        }
        if (value instanceof Double) {
            return MCast.toString((Double)value);
        }
        if (value instanceof Float) {
            return MCast.toString((Float)value);
        }
        if (value instanceof java.util.Date) {
            return MCast.toString((java.util.Date)value);
        }
        if (value instanceof Calendar) {
            return MCast.toString((Calendar)value);
        }
        return value.toString();
    }

    public static java.util.Date objectToDate(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof java.util.Date) {
            return (java.util.Date)value;
        }
        if (value instanceof Calendar) {
            return ((Calendar)value).getTime();
        }
        return MCast.toDate(String.valueOf(value), null);
    }

    public static Date toSqlDate(java.util.Date date) {
        return new Date(date.getTime());
    }

    public static String toString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    public static String toString(Object in) {
        if (in == null) {
            return "";
        }
        return OBJECT_TO_STRING.cast(in, "");
    }

    public static String toString(Object in, String def) {
        if (in == null) {
            return def;
        }
        return OBJECT_TO_STRING.cast(in, def);
    }

    public static Object toType(Object in, Class<?> type, Object def) {
        if (in == null) {
            return def;
        }
        if (type.isInstance(in)) {
            return in;
        }
        Caster<?, ?> caster = casters.get(in.getClass(), type);
        if (caster == null) {
            if (String.class.isAssignableFrom(type)) {
                return MCast.toString(in);
            }
            if (Boolean.TYPE.isAssignableFrom(type)) {
                return MCast.toboolean(in, def == null ? false : MCast.toboolean(def, false));
            }
            if (Integer.TYPE.isAssignableFrom(type)) {
                return MCast.toint(in, def == null ? 0 : MCast.toint(def, 0));
            }
            if (Long.TYPE.isAssignableFrom(type)) {
                return MCast.tolong(in, def == null ? 0L : MCast.tolong(def, 0L));
            }
            if (Double.TYPE.isAssignableFrom(type)) {
                return MCast.todouble(in, def == null ? 0.0 : MCast.todouble(def, 0.0));
            }
            if (Byte.TYPE.isAssignableFrom(type)) {
                return MCast.tobyte(in, def == null ? (byte)0 : MCast.tobyte(def, (byte)0));
            }
            if (Short.TYPE.isAssignableFrom(type)) {
                return MCast.toshort(in, def == null ? (short)0 : MCast.toshort(def, (short)0));
            }
            if (Float.TYPE.isAssignableFrom(type)) {
                return Float.valueOf(MCast.tofloat(in, def == null ? 0.0f : MCast.tofloat(def, 0.0f)));
            }
            caster = casters.get(Object.class, type);
        }
        if (caster == null) {
            return def;
        }
        return caster.cast(in, def);
    }

    public static Object getDefaultPrimitive(Class<?> type) {
        if (type == Integer.TYPE) {
            return 0;
        }
        if (type == Long.TYPE) {
            return 0L;
        }
        if (type == Short.TYPE) {
            return (short)0;
        }
        if (type == Double.TYPE) {
            return 0.0;
        }
        if (type == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (type == Byte.TYPE) {
            return (byte)0;
        }
        if (type == Boolean.TYPE) {
            return false;
        }
        return null;
    }

    static {
        MCast.addCaster(OBJECT_TO_BOOLEAN, true);
        MCast.addCaster(OBJECT_TO_INTEGER, true);
        MCast.addCaster(OBJECT_TO_BYTE, true);
        MCast.addCaster(OBJECT_TO_SHORT, true);
        MCast.addCaster(OBJECT_TO_LONG, true);
        MCast.addCaster(OBJECT_TO_DOUBLE, true);
        MCast.addCaster(OBJECT_TO_FLOAT, true);
        MCast.addCaster(OBJECT_TO_STRING, true);
        MCast.addCaster(OBJECT_TO_DATE, true);
        MCast.addCaster(OBJECT_TO_SQLDATE, true);
        MCast.addCaster(OBJECT_TO_CALENDAR, true);
        MCast.addCaster(DOUBLE_TO_STRING, true);
        MCast.addCaster(FLOAT_TO_STRING, true);
        MCast.addCaster(new ObjectToUUID(), true);
    }
}

