/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core;

import de.mhus.lib.core.MCast;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class MDate
extends Date {
    private static SimpleDateFormat iso8601DateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static SimpleDateFormat fileDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");

    public MDate() {
    }

    public MDate(long date) {
        super(date);
    }

    public MDate(Timestamp timestamp) {
        this(timestamp.getTime());
    }

    public MDate(String string) {
        Date date = MCast.toDate(string, null);
        this.setTime(date.getTime());
    }

    @Override
    public String toString() {
        return MDate.toIso8601(this);
    }

    public java.sql.Date toSqlDate() {
        return new java.sql.Date(this.getTime());
    }

    public Time toSqlTime() {
        return new Time(this.getTime());
    }

    public Timestamp toSqlTimestamp() {
        return new Timestamp(this.getTime());
    }

    public Calendar toCalendar() {
        return MCast.toCalendar(this);
    }

    public static boolean isEarlierAs(Date a, Date b) {
        return a.compareTo(b) < 0;
    }

    public static boolean isLaterAs(Date a, Date b) {
        return a.compareTo(b) > 0;
    }

    public static boolean isWorkDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int dayOfWeek = calendar.get(7);
        return dayOfWeek >= 2 && dayOfWeek <= 6;
    }

    public static boolean isWeekend(Date date) {
        return !MDate.isWorkDay(date);
    }

    public static String toIso8601(Date date) {
        return iso8601DateFormat.format(date);
    }

    public static String toFileFormat(Date date) {
        return fileDateFormat.format(date);
    }

    public static String toIsoDate(Date _in) {
        Calendar c = Calendar.getInstance();
        c.setTime(_in);
        return MDate.toIsoDate(c);
    }

    public static String toIsoDateTime(Date _in) {
        Calendar c = Calendar.getInstance();
        c.setTime(_in);
        return MDate.toIsoDateTime(c);
    }

    public static String toIsoDateTime(Calendar _in) {
        return _in.get(1) + "-" + MCast.toString(_in.get(2) + 1, 2) + "-" + MCast.toString(_in.get(5), 2) + " " + MCast.toString(_in.get(11), 2) + ":" + MCast.toString(_in.get(12), 2) + ":" + MCast.toString(_in.get(13), 2);
    }

    public static String toIsoDateTime(long timeStamp) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(timeStamp);
        return MDate.toIsoDateTime(c);
    }

    public static String toIsoDate(Calendar _in) {
        return _in.get(1) + "-" + MCast.toString(_in.get(2) + 1, 2) + "-" + MCast.toString(_in.get(5), 2);
    }

    public static String toIso8601(Calendar date) {
        return iso8601DateFormat.format(date);
    }

    public static String toFileFormat(Calendar date) {
        return fileDateFormat.format(date);
    }
}

