/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core;

import de.mhus.lib.core.MCast;
import de.mhus.lib.core.lang.MObject;
import de.mhus.lib.errors.MException;
import de.mhus.lib.errors.MRuntimeException;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class IProperties
extends MObject
implements Iterable<Map.Entry<String, Object>> {
    public abstract Object getProperty(String var1);

    @Deprecated
    public int getProperty(String name, int def) throws MException {
        return this.getInt(name, def);
    }

    public String getString(String name, String def) {
        Object out;
        try {
            out = this.getProperty(name);
        }
        catch (Throwable e) {
            return def;
        }
        if (out == null) {
            return def;
        }
        return String.valueOf(out);
    }

    public String getString(String name) throws MException {
        Object out = this.getProperty(name);
        if (out == null) {
            return null;
        }
        return String.valueOf(out);
    }

    public boolean getBoolean(String name, boolean def) {
        Object out;
        try {
            out = this.getProperty(name);
        }
        catch (Throwable e) {
            return def;
        }
        if (out == null) {
            return def;
        }
        if (out instanceof Boolean) {
            return (Boolean)out;
        }
        return MCast.toboolean(String.valueOf(out), def);
    }

    public boolean getBoolean(String name) throws MException {
        Object out = this.getProperty(name);
        if (out == null) {
            throw new MException(new Object[]{"value not found"});
        }
        if (out instanceof Boolean) {
            return (Boolean)out;
        }
        return MCast.toboolean(String.valueOf(out), false);
    }

    public int getInt(String name, int def) {
        Object out;
        try {
            out = this.getProperty(name);
        }
        catch (Throwable e) {
            return def;
        }
        if (out == null) {
            return def;
        }
        if (out instanceof Number) {
            return ((Number)out).intValue();
        }
        return MCast.toint(String.valueOf(out), def);
    }

    public long getLong(String name, long def) {
        Object out;
        try {
            out = this.getProperty(name);
        }
        catch (Throwable e) {
            return def;
        }
        if (out == null) {
            return def;
        }
        if (out instanceof Number) {
            return ((Number)out).longValue();
        }
        return MCast.tolong(String.valueOf(out), def);
    }

    public float getFloat(String name, float def) {
        Object out;
        try {
            out = this.getProperty(name);
        }
        catch (Throwable e) {
            return def;
        }
        if (out == null) {
            return def;
        }
        if (out instanceof Number) {
            return ((Number)out).floatValue();
        }
        return MCast.tofloat(String.valueOf(out), def);
    }

    public double getDouble(String name, double def) {
        Object out;
        try {
            out = this.getProperty(name);
        }
        catch (Throwable e) {
            return def;
        }
        if (out == null) {
            return def;
        }
        if (out instanceof Number) {
            return ((Number)out).doubleValue();
        }
        return MCast.todouble(String.valueOf(out), def);
    }

    public Calendar getCalendar(String name) throws MException {
        Object out = this.getProperty(name);
        if (out == null) {
            return null;
        }
        if (out instanceof Calendar) {
            return (Calendar)out;
        }
        return MCast.toCalendar(String.valueOf(out));
    }

    public Date getDate(String name) {
        try {
            Object out = this.getProperty(name);
            if (out == null) {
                return null;
            }
            if (out instanceof Date) {
                return (Date)out;
            }
            if (out instanceof Calendar) {
                return ((Calendar)out).getTime();
            }
            return MCast.toDate(String.valueOf(out), null);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public void setString(String name, String value) {
        this.setProperty(name, value);
    }

    public void setInt(String name, int value) {
        this.setProperty(name, value);
    }

    public void setLong(String name, long value) {
        this.setProperty(name, value);
    }

    public void setDouble(String name, double value) {
        this.setProperty(name, value);
    }

    public void setFloat(String name, float value) {
        this.setProperty(name, Float.valueOf(value));
    }

    public void setBoolean(String name, boolean value) {
        this.setProperty(name, value);
    }

    public void setCalendar(String name, Calendar value) {
        this.setProperty(name, value);
    }

    public void setDate(String name, Date value) {
        this.setProperty(name, value);
    }

    public void setNumber(String name, Number value) {
        if (value == null) {
            this.removeProperty(name);
            return;
        }
        if (value instanceof Integer) {
            this.setInt(name, (Integer)value);
        } else if (value instanceof Long) {
            this.setLong(name, (Long)value);
        } else if (value instanceof Float) {
            this.setFloat(name, ((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.setDouble(name, (Double)value);
        } else {
            throw new MRuntimeException(new Object[]{"Unknown number class", name, value.getClass()});
        }
    }

    public Number getNumber(String name, Number def) {
        Object out = this.getProperty(name);
        if (out == null) {
            return def;
        }
        if (out instanceof Number) {
            return (Number)out;
        }
        try {
            return MCast.todouble(out, 0.0);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public abstract boolean isProperty(String var1);

    public abstract void removeProperty(String var1);

    public abstract void setProperty(String var1, Object var2);

    public abstract boolean isEditable();

    public abstract Set<String> keys();

    @Override
    public Iterator<Map.Entry<String, Object>> iterator() {
        return new IPIterator();
    }

    private class IPEntry
    implements Map.Entry<String, Object> {
        private String key;

        public IPEntry(String next) {
            this.key = next;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            try {
                return IProperties.this.getProperty(this.key);
            }
            catch (Throwable e) {
                throw new MRuntimeException(new Object[]{e});
            }
        }

        @Override
        public Object setValue(Object value) {
            Object old = null;
            try {
                old = IProperties.this.getProperty(this.key);
            }
            catch (Throwable e1) {
                IProperties.this.log().t(this.key, e1);
            }
            try {
                IProperties.this.setProperty(this.key, value);
            }
            catch (Throwable e) {
                IProperties.this.log().t(this.key, e);
            }
            return old;
        }
    }

    private class IPIterator
    implements Iterator<Map.Entry<String, Object>> {
        private Iterator<String> keys;
        private String currentkey;

        IPIterator() {
            this.keys = IProperties.this.keys().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.keys.hasNext();
        }

        @Override
        public Map.Entry<String, Object> next() {
            this.currentkey = this.keys.next();
            return new IPEntry(this.currentkey);
        }

        @Override
        public void remove() {
            try {
                IProperties.this.removeProperty(this.currentkey);
            }
            catch (Throwable e) {
                IProperties.this.log().t(e);
            }
        }
    }
}

