/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.directory;

import de.mhus.lib.core.IProperties;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.parser.CompiledString;
import de.mhus.lib.core.parser.DefaultScriptPart;
import de.mhus.lib.core.parser.StringCompiler;
import de.mhus.lib.core.parser.StringPart;
import de.mhus.lib.core.util.ArraySet;
import de.mhus.lib.errors.MException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class ResourceNode
extends IProperties {
    protected ConfigStringCompiler compiler;
    protected HashMap<String, CompiledString> compiledCache;

    public abstract String[] getPropertyKeys();

    public abstract ResourceNode getNode(String var1);

    public abstract ResourceNode[] getNodes();

    public abstract ResourceNode[] getNodes(String var1);

    public abstract String[] getNodeKeys();

    public abstract String getName() throws MException;

    public InputStream getInputStream() {
        return this.getInputStream(null);
    }

    public abstract InputStream getInputStream(String var1);

    public String getExtracted(String key) throws MException {
        return this.getExtracted(key, null);
    }

    public String getExtracted(String key, String def) throws MException {
        return this.getExtracted(key, def, 0);
    }

    public abstract ResourceNode getParent();

    @Override
    public Set<String> keys() {
        return new ArraySet<String>(this.getPropertyKeys());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getExtracted(String key, String def, int level) throws MException {
        if (level > 10) {
            return def;
        }
        String value = this.getString(key, null);
        if (value == null) {
            return def;
        }
        if (value.indexOf(36) < 0) {
            return value;
        }
        ResourceNode resourceNode = this;
        synchronized (resourceNode) {
            CompiledString cached;
            if (this.compiler == null) {
                this.compiler = new ConfigStringCompiler();
                this.compiledCache = new HashMap();
            }
            if ((cached = this.compiledCache.get(key)) == null) {
                cached = this.compiler.compileString(value);
                this.compiledCache.put(key, cached);
            }
            return cached.execute(level == 0 ? null : new ConfigMap(level));
        }
    }

    public abstract URL getUrl();

    private class ConfigMap
    implements Map<String, Object> {
        private int level;

        private ConfigMap(int level) {
            this.level = level;
        }

        @Override
        public int size() {
            return 0;
        }

        public int getLevel() {
            return this.level;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean containsKey(Object key) {
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            return false;
        }

        @Override
        public Object get(Object key) {
            return null;
        }

        @Override
        public Object put(String key, Object value) {
            return null;
        }

        @Override
        public Object remove(Object key) {
            return null;
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> m) {
        }

        @Override
        public void clear() {
        }

        @Override
        public Set<String> keySet() {
            return null;
        }

        @Override
        public Collection<Object> values() {
            return null;
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return null;
        }
    }

    private class ConfigAttributePart
    implements StringPart {
        private String name;
        private String def;
        private ResourceNode config;

        public ConfigAttributePart(String part) {
            this.name = part;
            int pos = this.name.indexOf(44);
            if (pos > 0) {
                this.def = this.name.substring(pos + 1);
                this.name = this.name.substring(0, pos);
            }
            this.config = ResourceNode.this;
            while (this.name.startsWith("../")) {
                this.config = this.config.getParent();
                this.name = this.name.substring(3);
                if (this.config != null) continue;
                break;
            }
        }

        @Override
        public void execute(StringBuffer out, Map<String, Object> attributes) throws MException {
            int level = 0;
            if (attributes != null && attributes instanceof ConfigMap) {
                level = ((ConfigMap)attributes).getLevel();
            }
            if (this.config == null) {
                out.append(this.def);
            } else {
                out.append(this.config.getExtracted(this.name, this.def, level));
            }
        }

        @Override
        public void dump(int level, StringBuffer out) {
            MString.appendRepeating(level, ' ', out);
            out.append(this.getClass().getCanonicalName()).append(this.name).append("(").append(this.def).append(")");
        }
    }

    private class RootAttributePart
    implements StringPart {
        private String name;
        private String def;
        private ResourceNode root;

        public RootAttributePart(String part) {
            this.name = MString.afterIndex(part, '.');
            this.root = ResourceNode.this;
            while (this.root.getParent() != null && this.root.getParent() != this.root) {
                this.root = this.root.getParent();
            }
            int pos = this.name.indexOf(44);
            if (pos > 0) {
                this.def = this.name.substring(pos + 1);
                this.name = this.name.substring(0, pos);
            }
        }

        @Override
        public void execute(StringBuffer out, Map<String, Object> attributes) throws MException {
            out.append(this.root.getString(this.name, this.def));
        }

        @Override
        public void dump(int level, StringBuffer out) {
            MString.appendRepeating(level, ' ', out);
            out.append(this.getClass().getCanonicalName()).append(this.name).append("(").append(this.def).append(")");
        }
    }

    private class ConfigStringCompiler
    extends StringCompiler {
        private ConfigStringCompiler() {
        }

        @Override
        protected StringPart createDefaultAttributePart(String part) {
            if (part.startsWith("root.")) {
                return new RootAttributePart(part);
            }
            if (part.startsWith(">>>")) {
                return new DefaultScriptPart(part);
            }
            return new ConfigAttributePart(part);
        }
    }
}

