/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.directory;

import de.mhus.lib.core.MString;
import de.mhus.lib.core.directory.MResourceProvider;
import de.mhus.lib.core.directory.ResourceNode;
import de.mhus.lib.errors.MException;
import java.io.InputStream;
import java.net.URL;

public class ClassLoaderResourceProvider
extends MResourceProvider<ResourceNode> {
    private ClassLoader loader;

    public ClassLoaderResourceProvider() {
        this(ClassLoaderResourceProvider.class.getClassLoader());
    }

    public ClassLoaderResourceProvider(ClassLoader loader) {
        this.loader = loader;
    }

    @Override
    public ResourceNode getResource(String name) {
        return new CLResourceNode(this.loader, name);
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public void setClassLoader(ClassLoader loader) {
        this.loader = loader;
    }

    private static class CLResourceNode
    extends ResourceNode {
        private String name;
        private ClassLoader loader;

        public CLResourceNode(ClassLoader loader, String name) {
            this.loader = loader;
            this.name = name;
        }

        @Override
        public String[] getPropertyKeys() {
            return new String[0];
        }

        @Override
        public ResourceNode getNode(String key) {
            return null;
        }

        @Override
        public ResourceNode[] getNodes() {
            return new ResourceNode[0];
        }

        @Override
        public ResourceNode[] getNodes(String key) {
            return null;
        }

        @Override
        public String[] getNodeKeys() {
            return new String[0];
        }

        @Override
        public String getName() throws MException {
            return MString.afterLastIndex(this.name, '/');
        }

        @Override
        public InputStream getInputStream(String key) {
            if (key == null) {
                return this.loader.getResourceAsStream(this.name);
            }
            return null;
        }

        @Override
        public ResourceNode getParent() {
            return null;
        }

        @Override
        public Object getProperty(String name) {
            return null;
        }

        @Override
        public boolean isProperty(String name) {
            return false;
        }

        @Override
        public void removeProperty(String key) {
        }

        @Override
        public void setProperty(String key, Object value) {
        }

        @Override
        public boolean isEditable() {
            return false;
        }

        @Override
        public URL getUrl() {
            return this.loader.getResource(this.name);
        }
    }
}

