/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.console;

import de.mhus.lib.core.console.Console;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ConsoleTable {
    public List<String> header = new ArrayList<String>();
    public List<List<String>> content = new ArrayList<List<String>>();
    private int maxColSize = -1;

    public List<String> addRow() {
        ArrayList<String> row = new ArrayList<String>();
        this.content.add(row);
        return row;
    }

    public void addRowValues(String ... values) {
        List<String> row = this.addRow();
        for (String v : values) {
            row.add(v);
        }
    }

    public List<String> getHeader() {
        return this.header;
    }

    public void setHeaderValues(String ... values) {
        List<String> row = this.getHeader();
        row.clear();
        for (String v : values) {
            row.add(v);
        }
    }

    public void print(Console console) {
        this.setMaxColSize(console.getWidth());
        this.print((PrintStream)console);
    }

    public void print(PrintStream out) {
        int[] sizes = new int[this.header.size()];
        this.updateSizes(sizes, this.header);
        for (List<String> row : this.content) {
            this.updateSizes(sizes, row);
        }
        String headerLine = this.getRow(sizes, this.header, " | ");
        out.println(headerLine);
        out.println(this.underline(headerLine.length()));
        for (List<String> row : this.content) {
            out.println(this.getRow(sizes, row, " | "));
        }
    }

    private String underline(int length) {
        char[] exmarks = new char[length];
        Arrays.fill(exmarks, '-');
        return new String(exmarks);
    }

    private String getRow(int[] sizes, List<String> row, String separator) {
        StringBuilder line = new StringBuilder();
        int c = 0;
        for (String cell : row) {
            if (cell == null) {
                cell = "";
            }
            if (this.maxColSize > 0 && cell.length() > this.maxColSize) {
                cell = cell.substring(0, this.maxColSize - 1);
            }
            cell = cell.replaceAll("\n", "");
            line.append(String.format("%-" + sizes[c] + "s", cell));
            if (c + 1 < row.size()) {
                line.append(separator);
            }
            ++c;
        }
        return line.toString();
    }

    private void updateSizes(int[] sizes, List<String> row) {
        int c = 0;
        for (String cellContent : row) {
            int cellSize = cellContent != null ? cellContent.length() : 0;
            int n = cellSize = this.maxColSize > 0 ? Math.min(cellSize, this.maxColSize) : cellSize;
            if (cellSize > sizes[c]) {
                sizes[c] = cellSize;
            }
            ++c;
        }
    }

    public int getMaxColSize() {
        return this.maxColSize;
    }

    public void setMaxColSize(int maxColSize) {
        this.maxColSize = maxColSize;
    }
}

