/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core;

import de.mhus.lib.core.system.DefaultSingleton;
import de.mhus.lib.core.system.DummyClass;
import de.mhus.lib.core.system.ISingleton;
import de.mhus.lib.core.system.ISingletonFactory;
import de.mhus.lib.core.system.SingletonInitialize;

public class MSingleton {
    private static ISingleton singleton;
    protected static Boolean trace;

    private MSingleton() {
    }

    public static synchronized ISingleton get() {
        if (singleton == null) {
            block9: {
                try {
                    ISingletonFactory factory;
                    ISingleton obj = null;
                    String path = "de.mhus.lib.mutable.SingletonFactory";
                    if (System.getProperty("mhu.lib.singleton.factory") != null) {
                        path = System.getProperty("mhu.lib.singleton.factory");
                    }
                    if (MSingleton.isDirtyTrace()) {
                        System.out.println("--- MSingletonFactory:" + path);
                    }
                    if ((factory = (ISingletonFactory)Class.forName(path).newInstance()) != null) {
                        obj = factory.createSingleton();
                    }
                    singleton = obj;
                }
                catch (Throwable t) {
                    if (!MSingleton.isDirtyTrace()) break block9;
                    t.printStackTrace();
                }
            }
            if (singleton == null) {
                singleton = new DefaultSingleton();
            }
            if (MSingleton.isDirtyTrace()) {
                System.out.println("--- MSingleton: " + singleton.getClass().getCanonicalName());
            }
            if (singleton instanceof SingletonInitialize) {
                ((SingletonInitialize)((Object)singleton)).doInitialize(DummyClass.class.getClassLoader());
            }
        }
        return singleton;
    }

    public static boolean isDirtyTrace() {
        if (trace == null) {
            trace = "true".equals(System.getProperty("mhu.lib.singleton.trace"));
        }
        return trace;
    }

    public static boolean isTrace(String name) {
        String value;
        if (MSingleton.isDirtyTrace()) {
            System.out.println("--- Ask for trace: " + name);
        }
        if ((value = System.getProperty(name + ".trace")) != null) {
            return "true".equals(value);
        }
        return MSingleton.get().isTrace(name);
    }
}

