/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.system;

import de.mhus.lib.core.MActivator;
import de.mhus.lib.core.activator.ActivatorImpl;
import de.mhus.lib.core.config.HashConfig;
import de.mhus.lib.core.config.IConfig;
import de.mhus.lib.core.config.XmlConfigFile;
import de.mhus.lib.core.lang.BaseControl;
import de.mhus.lib.core.logging.ConsoleFactory;
import de.mhus.lib.core.logging.Log;
import de.mhus.lib.core.logging.LogFactory;
import de.mhus.lib.core.service.ConfigProvider;
import de.mhus.lib.core.system.ISingleton;
import de.mhus.lib.core.system.SingletonInitialize;
import java.io.File;

public class DefaultSingleton
implements ISingleton,
SingletonInitialize {
    private ConsoleFactory logFactory;
    private File baseDir;
    private IConfig config;
    private BaseControl baseControl;
    private ConfigProvider configProvider;

    @Override
    public Log createLog(Object owner) {
        String name = null;
        name = owner == null ? "?" : (owner instanceof Class ? ((Class)owner).getName() : String.valueOf(owner));
        return this.logFactory.getInstance(name);
    }

    @Override
    public void doInitialize(ClassLoader coreLoader) {
        this.logFactory = new ConsoleFactory();
        this.baseDir = new File(".");
    }

    public synchronized IConfig getConfig() {
        if (this.config == null) {
            File file = new File(this.baseDir, "config.xml");
            if (file.exists() && file.isFile()) {
                try {
                    this.config = new XmlConfigFile(file);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.config == null) {
                this.config = new HashConfig();
            }
        }
        return this.config;
    }

    @Override
    public synchronized BaseControl getBaseControl() {
        if (this.baseControl == null) {
            this.baseControl = new BaseControl();
        }
        return this.baseControl;
    }

    @Override
    public MActivator createActivator() {
        return new ActivatorImpl();
    }

    @Override
    public LogFactory getLogFactory() {
        return this.logFactory;
    }

    @Override
    public synchronized ConfigProvider getConfigProvider() {
        if (this.configProvider == null) {
            this.configProvider = new ConfigProvider(this.getConfig());
        }
        return this.configProvider;
    }
}

