/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.logging;

import de.mhus.lib.core.MSystem;

public abstract class Log {
    protected boolean localTrace = true;
    protected String name;

    public abstract boolean isDebugEnabled();

    public abstract boolean isErrorEnabled();

    public abstract boolean isFatalEnabled();

    public abstract boolean isInfoEnabled();

    public abstract boolean isTraceEnabled();

    public abstract boolean isWarnEnabled();

    public void t(Object ... msg) {
        if (!this.isTrace()) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        Throwable error = null;
        for (Object o : msg) {
            error = this.serialize(sb, o, error);
        }
        this.trace(sb.toString(), error);
    }

    private Throwable serialize(StringBuffer sb, Object o, Throwable error) {
        if (o == null) {
            sb.append("[null]");
        } else if (o instanceof Throwable) {
            if (error == null) {
                return (Throwable)o;
            }
            sb.append("[").append(o).append("]");
        } else if (o.getClass().isArray()) {
            sb.append("{");
            for (Object p : (Object[])o) {
                error = this.serialize(sb, p, error);
            }
            sb.append("}");
        } else {
            sb.append("[").append(o).append("]");
        }
        return error;
    }

    public void tt(Object ... msg) {
        if (!this.isTraceEnabled()) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        Throwable error = null;
        for (Object o : msg) {
            error = this.serialize(sb, o, error);
        }
        this.trace(sb.toString(), error);
    }

    public void d(Object ... msg) {
        if (!this.isDebugEnabled()) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        Throwable error = null;
        for (Object o : msg) {
            error = this.serialize(sb, o, error);
        }
        this.debug(sb.toString(), error);
    }

    public void i(Object ... msg) {
        if (!this.isInfoEnabled()) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        Throwable error = null;
        for (Object o : msg) {
            error = this.serialize(sb, o, error);
        }
        this.info(sb.toString(), error);
    }

    public void w(Object ... msg) {
        if (!this.isWarnEnabled()) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        Throwable error = null;
        for (Object o : msg) {
            error = this.serialize(sb, o, error);
        }
        this.warn(sb.toString(), error);
    }

    public void e(Object ... msg) {
        if (!this.isErrorEnabled()) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        Throwable error = null;
        for (Object o : msg) {
            error = this.serialize(sb, o, error);
        }
        this.error(sb.toString(), error);
    }

    public void f(Object ... msg) {
        StringBuffer sb = new StringBuffer();
        Throwable error = null;
        for (Object o : msg) {
            error = this.serialize(sb, o, error);
        }
        this.fatal(sb.toString(), error);
    }

    public abstract void trace(Object var1);

    public abstract void trace(Object var1, Throwable var2);

    public abstract void debug(Object var1);

    public abstract void debug(Object var1, Throwable var2);

    public abstract void info(Object var1);

    public abstract void info(Object var1, Throwable var2);

    public abstract void warn(Object var1);

    public abstract void warn(Object var1, Throwable var2);

    public abstract void error(Object var1);

    public abstract void error(Object var1, Throwable var2);

    public abstract void fatal(Object var1);

    public abstract void fatal(Object var1, Throwable var2);

    public void setTrace(boolean localTrace) {
        this.localTrace = localTrace;
    }

    public boolean isTrace() {
        return this.localTrace;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return MSystem.toString(this, this.getName());
    }

    public static enum LEVEL {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR,
        FATAL;

    }
}

