/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.io;

import java.io.PrintWriter;
import java.io.Writer;

public class CSVWriter {
    static final boolean DEBUGGING = false;
    private static final String lineSeparator = "\r\n";
    private PrintWriter pw;
    private final boolean trim;
    private boolean wasPreviousField = false;
    private char quote;
    private char separator;
    private int quoteLevel;
    private String defaultNullValue = "";

    public CSVWriter(Writer pw) {
        this(pw, 1, ',', '\"', true);
    }

    public CSVWriter(Writer pw, int quoteLevel, char separator, char quote, boolean trim) {
        this.pw = pw instanceof PrintWriter ? (PrintWriter)pw : new PrintWriter(pw);
        if (this.pw == null) {
            throw new IllegalArgumentException("invalid Writer");
        }
        this.quoteLevel = quoteLevel;
        this.separator = separator;
        this.quote = quote;
        this.trim = trim;
    }

    public void close() {
        if (this.pw != null) {
            this.pw.close();
            this.pw = null;
        }
    }

    public void setDefaultNullValue(String in) {
        this.defaultNullValue = in;
    }

    public void nl() {
        if (this.pw == null) {
            throw new IllegalArgumentException("attempt to use a closed CSVWriter");
        }
        this.pw.write(lineSeparator);
        this.wasPreviousField = false;
    }

    public void print(Object ... values) {
        String[] v = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            v[i] = String.valueOf(values[i]);
        }
        this.put(v);
    }

    public void println(Object ... values) {
        String[] v = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            v[i] = String.valueOf(values[i]);
        }
        this.put(v);
        this.nl();
    }

    public void put(String ... values) {
        if (this.pw == null) {
            throw new IllegalArgumentException("attempt to use a closed CSVWriter");
        }
        if (values == null || values.length == 0) {
            return;
        }
        for (String s : values) {
            if (s == null) {
                if (this.defaultNullValue == null) {
                    this.nl();
                    return;
                }
                s = this.defaultNullValue;
            }
            if (this.wasPreviousField) {
                this.pw.write(this.separator);
            }
            if (this.trim) {
                s = s.trim();
            }
            if (s.indexOf(this.quote) >= 0) {
                this.pw.write(this.quote);
                for (int i = 0; i < s.length(); ++i) {
                    char c = s.charAt(i);
                    if (c == this.quote) {
                        this.pw.write(this.quote);
                        this.pw.write(this.quote);
                        continue;
                    }
                    this.pw.write(c);
                }
                this.pw.write(this.quote);
            } else if (this.quoteLevel == 2 || this.quoteLevel == 1 && s.indexOf(32) >= 0 || s.indexOf(this.separator) >= 0) {
                this.pw.write(this.quote);
                this.pw.write(s);
                this.pw.write(this.quote);
            } else {
                this.pw.write(s);
            }
            this.wasPreviousField = true;
        }
    }

    public static void main(String[] args) {
    }
}

