/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.config;

import de.mhus.lib.core.MFile;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.MXml;
import de.mhus.lib.core.config.DirConfig;
import de.mhus.lib.core.config.HashConfig;
import de.mhus.lib.core.config.JsonConfig;
import de.mhus.lib.core.config.JsonConfigFile;
import de.mhus.lib.core.config.PropertiesConfig;
import de.mhus.lib.core.config.PropertiesConfigFile;
import de.mhus.lib.core.config.XmlConfig;
import de.mhus.lib.core.config.XmlConfigFile;
import de.mhus.lib.core.directory.WritableDirectoryNode;
import de.mhus.lib.core.lang.IBase;
import de.mhus.lib.core.util.Rfc1738;
import java.io.File;
import java.net.URI;

public class MConfigFactory
implements IBase {
    public WritableDirectoryNode createConfigFor(File file) throws Exception {
        if (file.isDirectory()) {
            return new DirConfig(file);
        }
        String key = file.getName();
        if (key.endsWith(".xml")) {
            XmlConfigFile out = new XmlConfigFile(file);
            out.setName(MFile.getFileNameOnly(key));
            out.setString("__path", file.getAbsolutePath());
            return out;
        }
        if (key.endsWith(".properties")) {
            PropertiesConfigFile out = new PropertiesConfigFile(file);
            out.setName(MFile.getFileNameOnly(key));
            out.setString("__path", file.getAbsolutePath());
            return out;
        }
        if (key.endsWith(".json")) {
            JsonConfigFile out = new JsonConfigFile(file);
            out.setName(MFile.getFileNameOnly(key));
            out.setString("__path", file.getAbsolutePath());
            return out;
        }
        return null;
    }

    public WritableDirectoryNode createConfigFor(URI uri) throws Exception {
        if (uri == null) {
            return null;
        }
        String key = uri.getPath();
        if (key == null) {
            key = uri.toString();
        }
        if (key.endsWith(".xml")) {
            XmlConfigFile out = new XmlConfigFile(uri.toURL().openStream());
            out.setName(MFile.getFileNameOnly(key));
            out.setString("__path", uri.getPath());
            out.setString("__host", uri.getHost());
            out.setInt("__port", uri.getPort());
            out.setString("__user", uri.getUserInfo());
            return out;
        }
        if (key.endsWith(".properties")) {
            PropertiesConfigFile out = new PropertiesConfigFile(uri.toURL().openStream());
            out.setName(MFile.getFileNameOnly(key));
            out.setString("__path", uri.getPath());
            out.setString("__host", uri.getHost());
            out.setInt("__port", uri.getPort());
            out.setString("__user", uri.getUserInfo());
            return out;
        }
        if (key.endsWith(".json")) {
            JsonConfigFile out = new JsonConfigFile(uri.toURL().openStream());
            out.setName(MFile.getFileNameOnly(key));
            out.setString("__path", uri.getPath());
            out.setString("__host", uri.getHost());
            out.setInt("__port", uri.getPort());
            out.setString("__user", uri.getUserInfo());
            return out;
        }
        return null;
    }

    public WritableDirectoryNode createConfigForFile(String key) throws Exception {
        if (key == null) {
            return null;
        }
        if (key.endsWith(".xml")) {
            return new XmlConfig();
        }
        if (key.endsWith(".properties")) {
            return new PropertiesConfig();
        }
        if (key.endsWith(".json")) {
            return new JsonConfig();
        }
        return null;
    }

    public WritableDirectoryNode toConfig(String configString) throws Exception {
        if (MString.isEmptyTrim(configString)) {
            return new HashConfig();
        }
        if (configString.startsWith("[") || configString.startsWith("{")) {
            return new JsonConfig(configString);
        }
        if (configString.startsWith("<?")) {
            return new XmlConfig(MXml.loadXml(configString).getDocumentElement());
        }
        if (configString.contains("=")) {
            if (configString.contains("&")) {
                return new HashConfig(Rfc1738.explode(configString));
            }
            return new PropertiesConfig(configString);
        }
        return null;
    }
}

