/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core;

import de.mhus.lib.core.MString;
import de.mhus.lib.core.logging.Log;
import de.mhus.lib.core.logging.MLogger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.URL;
import java.util.Map;
import java.util.Properties;

public class MSystem {
    private static Log log = MLogger.getLog(MSystem.class);

    public static String getHostname() {
        String out = System.getenv().get("COMPUTERNAME");
        if (out == null) {
            out = System.getenv().get("HOSTNAME");
        }
        if (out == null) {
            RuntimeMXBean rt = ManagementFactory.getRuntimeMXBean();
            String name = rt.getName();
            out = MString.afterIndex(name, '@');
        }
        return out;
    }

    public static String getPid() {
        RuntimeMXBean rt = ManagementFactory.getRuntimeMXBean();
        String name = rt.getName();
        return MString.beforeIndex(name, '@');
    }

    public static Properties loadProperties(Object owner, Properties properties, String propertyFile) {
        log.d("Loading properties", propertyFile);
        if (properties == null) {
            properties = new Properties();
        }
        try {
            URL m_url = MSystem.locateResource(owner, propertyFile);
            if (m_url == null) {
                log.w("Properties file not found", propertyFile);
                return properties;
            }
            log.i("load", m_url);
            InputStream stream = m_url.openStream();
            properties.load(stream);
            stream.close();
        }
        catch (IOException e) {
            log.i("Error loading properties file", propertyFile, e.toString());
        }
        return properties;
    }

    public static URL locateResource(Object owner, String propertyFile) throws IOException {
        File f;
        URL url = null;
        String location = System.getProperty(propertyFile + ".file");
        if (url == null && location != null && (f = new File(location)).exists() && f.isFile()) {
            url = f.toURL();
        }
        if ((f = new File(propertyFile)).exists() && f.isFile()) {
            return f.toURL();
        }
        f = new File("config/" + propertyFile);
        if (f.exists() && f.isFile()) {
            return f.toURL();
        }
        try {
            File f2;
            String configurationPath = System.getenv("CONFIGURATION");
            if (url == null && configurationPath != null && (f2 = new File(configurationPath + "/" + propertyFile)).exists() && f2.isFile()) {
                url = f2.toURL();
            }
        }
        catch (SecurityException e) {
            // empty catch block
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (url == null && loader != null) {
            url = loader.getResource(propertyFile);
        }
        if (owner != null && url == null) {
            url = owner.getClass().getResource("/" + owner.getClass().getPackage().getName().replaceAll("\\.", "/") + "/" + propertyFile);
        }
        if (owner != null && url == null) {
            url = owner.getClass().getResource(owner.getClass().getPackage().getName().replaceAll("\\.", "/") + "/" + propertyFile);
        }
        if (url != null) {
            return url;
        }
        throw new FileNotFoundException("Cannot locate resource: " + propertyFile);
    }

    public static void beep() {
        System.out.print("\u0007");
        System.out.flush();
    }

    public static String findSource(int returns) {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        if (stack.length > returns) {
            return stack[returns].getClassName();
        }
        return "?";
    }

    public static String getMainClassName() {
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            if (!entry.getKey().startsWith("JAVA_MAIN_CLASS")) continue;
            return entry.getValue();
        }
        return null;
    }

    public static String getTmpDirectory() {
        return System.getProperty("java.io.tmpdir");
    }

    public static String toString(Object sender, Object ... attributes) {
        StringBuffer sb = new StringBuffer();
        sb.append('[').append(sender == null ? "?" : sender.getClass().getSimpleName()).append(':');
        boolean first = true;
        for (Object a : attributes) {
            if (!first) {
                sb.append(',');
            } else {
                first = false;
            }
            if (a == null) {
                sb.append("null");
                continue;
            }
            sb.append(a.toString());
        }
        sb.append(']');
        return sb.toString();
    }

    public static <A extends Annotation> A findAnnotation(Class<?> clazz, Class<A> annotation) {
        for (Class<?> current = clazz; current != null; current = current.getSuperclass()) {
            if (!current.isAnnotationPresent(annotation)) continue;
            return current.getAnnotation(annotation);
        }
        return null;
    }

    public static boolean equals(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null) {
            return false;
        }
        return a.equals(b);
    }
}

