/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core;

import de.mhus.lib.annotations.jmx.JmxManaged;
import de.mhus.lib.core.MCast;
import de.mhus.lib.core.jmx.MJmx;
import de.mhus.lib.core.service.UniqueId;

@JmxManaged(descrition="Simple Stop Watch")
public class MStopWatch
extends MJmx {
    private static final int STATUS_INITIAL = 0;
    private static final int STATUS_RUNNING = 1;
    private static final int STATUS_STOPPED = 2;
    private long start = 0L;
    private long stop = 0L;
    private String name;

    public MStopWatch() {
        this.name = "StopWatch " + this.base(UniqueId.class).nextUniqueId();
    }

    public MStopWatch(String name) {
        this.name = name;
    }

    public void start() {
        if (this.start == 0L) {
            this.start = System.currentTimeMillis();
        }
    }

    public void stop() {
        if (this.start != 0L && this.stop == 0L) {
            this.stop = System.currentTimeMillis();
        }
    }

    public long getCurrentTime() {
        if (this.start == 0L) {
            return 0L;
        }
        if (this.stop == 0L) {
            return System.currentTimeMillis() - this.start;
        }
        return this.stop - this.start;
    }

    public void reset() {
        this.start = 0L;
        this.stop = 0L;
    }

    public int getStatus() {
        if (this.start == 0L && this.stop == 0L) {
            return 0;
        }
        if (this.stop == 0L) {
            return 1;
        }
        return 2;
    }

    public boolean isRunning() {
        return this.getStatus() == 1;
    }

    @JmxManaged(descrition="Current status of the watch")
    public String getStatusAsString() {
        switch (this.getStatus()) {
            case 0: {
                return "initial";
            }
            case 1: {
                return "running";
            }
            case 2: {
                return "stopped";
            }
        }
        return "unknown";
    }

    public long getCurrentSeconds() {
        return this.getCurrentTime() / 1000L;
    }

    public long getCurrentMinutes() {
        return this.getCurrentSeconds() / 60L;
    }

    public String getCurrentMinutesAsString() {
        long sec = this.getCurrentSeconds();
        return String.valueOf(sec / 60L) + ':' + MCast.toString((int)(sec % 60L), 2);
    }

    @JmxManaged(descrition="Currently elapsed time")
    public String getCurrentTimeAsString() {
        return this.getCurrentTimeAsString(true);
    }

    public String getCurrentTimeAsString(boolean longFormat) {
        long msec = this.getCurrentTime();
        long sec = msec / 1000L;
        long min = sec / 60L;
        if (!longFormat && min < 60L) {
            return MCast.toString((int)min, 2) + ':' + MCast.toString((int)(sec % 60L), 2) + '.' + MCast.toString((int)(msec % 1000L), 3);
        }
        long hours = min / 60L;
        if (!longFormat && hours < 24L) {
            return MCast.toString((int)hours, 2) + ':' + MCast.toString((int)(min % 60L), 2) + ':' + MCast.toString((int)(sec % 60L), 2) + '.' + MCast.toString((int)(msec % 1000L), 3);
        }
        long days = hours / 24L;
        return MCast.toString((int)days, 2) + ' ' + MCast.toString((int)(hours % 24L), 2) + ':' + MCast.toString((int)(min % 60L), 2) + ':' + MCast.toString((int)(sec % 60L), 2) + '.' + MCast.toString((int)(msec % 1000L), 3);
    }

    @JmxManaged(descrition="Name of the watch")
    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        return this.name + "=" + this.getCurrentTimeAsString() + "@MStopWatch";
    }
}

