package de.mhus.lib.core.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;

import de.mhus.lib.core.directory.ClassLoaderDirectory;
import de.mhus.lib.core.directory.DirectoryNode;
import de.mhus.lib.core.directory.MDirectory;
import de.mhus.lib.core.lang.BaseControl;
import de.mhus.lib.core.lang.MObject;

public class MNlsFactory extends MObject {

	@SuppressWarnings("unused")
	private DirectoryNode config;
	
	public MNlsFactory() {
		this(null);
//		forkBase();
	}
	
	public MNlsFactory(DirectoryNode config) {
		this.config = config;
	}
	
	public MNls create(Object owner) {
		try {
			installBase();
			return load(null, owner.getClass(),null, null);
		} finally {
			leaveBase();
		}
	}
	
	public MNls load(MDirectory res, Class<?> owner, String resourceName, String locale) {
		try {
			// if (res == null) res = base(MDirectory.class);
			
			if (resourceName == null)
				resourceName = owner.getCanonicalName().replace('.', '/');
			
			if ( res == null ) {
				if (owner != null)
					res = new ClassLoaderDirectory(owner.getClassLoader());
				else
					res = new ClassLoaderDirectory();
			}

			if (locale == null)
				locale = getDefaultLocale();
			
			InputStream is = null;
			Properties properties = new Properties();
			
			is = res.getInputStream(locale.toString() + "/" + resourceName + ".properties" );
			if (is==null)
				is = res.getInputStream(getDefaultLocale()  + "/" + resourceName + ".properties" );
			if (is==null)
				is = res.getInputStream(resourceName + ".properties" );

			if (is != null) {
				log().t("Load Resource",resourceName,locale);
				properties.load(is);
				is.close();
			} else {
				log().d("Resource not found",resourceName,locale);
			}

			return new MNls(properties,"");
			
		} catch (Exception e) {
			log().info(e);
		}

		return new MNls();
	}
	
	public String getDefaultLocale() {
		return Locale.getDefault().toString();
	}

	public MNls load(InputStream is) {
		Properties properties = new Properties();
		try {
			properties.load(is);
		} catch (IOException e) {
			log().i(e);
		}
		return new MNls(properties,"");
	}

}
