package de.mhus.lib.core.directory;

import java.io.InputStream;
import java.net.URL;

public class ClassLoaderDirectory extends MDirectory {

	private ClassLoader loader;
	
	public ClassLoaderDirectory() {
		//this(Thread.currentThread().getContextClassLoader());
		this(ClassLoaderDirectory.class.getClassLoader());
	}
	
	public ClassLoaderDirectory(ClassLoader loader) {
		this.loader = loader;
	}

	@Override
	public URL getResource(String name) {
		return loader.getResource(name);
	}

	@Override
	public InputStream getInputStream(String resName) {
		return loader.getResourceAsStream(resName);
	}

	public ClassLoader getClassLoader() {
		return loader;
	}

	public void setClassLoader(ClassLoader loader) {
		this.loader = loader;
	}

}
