package de.mhus.lib.core.config;

import java.util.HashMap;
import java.util.Properties;

import de.mhus.lib.core.MException;
import de.mhus.lib.core.directory.DirectoryNode;
import de.mhus.lib.core.directory.WritableDirectoryNode;

public class NodeConfig extends PropertiesConfig {
	
	private HashMap<String, DirectoryNode> configurations = new HashMap<String, DirectoryNode>();
	
	public NodeConfig() {
		super(new Properties());
	}
	
	public void setConfig(String name, DirectoryNode config) {
		configurations.put(name, config);
	}
	
	public DirectoryNode getNode(String key) {
		return configurations.get(key);
	}

	public DirectoryNode[] getNodes(String key) {
		return new DirectoryNode[] { getNode(key)};
//		return configurations.values().toArray(new IConfig[configurations.size()]);
	}

	public String[] getConfigKeys() {
		return configurations.keySet().toArray(new String[configurations.size()]);
	}

	public WritableDirectoryNode createConfig(String key) throws MException {
		NodeConfig newConfig = new NodeConfig();
		setConfig(key, newConfig);
		return newConfig;
	}

}
