package de.mhus.lib.core.config;

import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Map.Entry;
import java.util.Set;

import de.mhus.lib.core.MException;
import de.mhus.lib.core.directory.DirectoryNode;
import de.mhus.lib.core.directory.WritableDirectoryNode;

public class DirectoryToConfigWrapper extends IConfig {

	private WritableDirectoryNode node;

	public DirectoryToConfigWrapper(WritableDirectoryNode node) {
		this.node = node;
	}
	
	@Override
	public Object getProperty(String name) throws MException {
		return node.getProperty(name);
	}

	@Override
	public WritableDirectoryNode createConfig(String key) throws MException {
		return node.createConfig(key);
	}

	@SuppressWarnings("deprecation")
	@Override
	public int getProperty(String name, int def) throws MException {
		return node.getProperty(name, def);
	}

	@Override
	public int moveConfig(DirectoryNode config, int newPos) throws MException {
		return node.moveConfig(config, newPos);
	}

	@Override
	public String getString(String name, String def) throws MException {
		return node.getString(name, def);
	}

	@Override
	public String[] getPropertyKeys() {
		return node.getPropertyKeys();
	}

	@Override
	public DirectoryNode getNode(String key) {
		return node.getNode(key);
	}

	@Override
	public boolean getBoolean(String name, boolean def) throws MException {
		return node.getBoolean(name, def);
	}

	@Override
	public void removeConfig(DirectoryNode config) throws MException {
		node.removeConfig(config);
	}

	@Override
	public DirectoryNode[] getNodes() {
		return node.getNodes();
	}

	@Override
	public int getInt(String name, int def) throws MException {
		return node.getInt(name, def);
	}

	@Override
	public DirectoryNode[] getNodes(String key) {
		return node.getNodes(key);
	}

	@Override
	public void setString(String name, String value) throws MException {
		node.setString(name, value);
	}

	@Override
	public int hashCode() {
		return node.hashCode();
	}

	@Override
	public long getLong(String name, long def) throws MException {
		return node.getLong(name, def);
	}

	@Override
	public String[] getNodeKeys() {
		return node.getNodeKeys();
	}

	@Override
	public String getName() throws MException {
		return node.getName();
	}

	@Override
	public String toString() {
		return node.toString();
	}

	@Override
	public float getFloat(String name, float def) throws MException {
		return node.getFloat(name, def);
	}

	@Override
	public InputStream getInputStream(String key) {
		return node.getInputStream(key);
	}

	@Override
	public String getExtracted(String key) throws MException {
		return node.getExtracted(key);
	}

	@Override
	public double getDouble(String name, double def) throws MException {
		return node.getDouble(name, def);
	}

	@Override
	public Calendar getCalendar(String name) throws MException {
		return node.getCalendar(name);
	}

	@Override
	public String getExtracted(String key, String def) throws MException {
		return node.getExtracted(key, def);
	}

	@Override
	public Date getDate(String name) {
		return node.getDate(name);
	}

	@Override
	public DirectoryNode getParent() {
		return node.getParent();
	}

	@Override
	public Set<String> keys() {
		return node.keys();
	}

	@Override
	public void setInt(String name, int value) throws MException {
		node.setInt(name, value);
	}

	@Override
	public void setLong(String name, long value) throws MException {
		node.setLong(name, value);
	}

	@Override
	public void setDouble(String name, double value) throws MException {
		node.setDouble(name, value);
	}

	@Override
	public void setFloat(String name, float value) throws MException {
		node.setFloat(name, value);
	}

	@Override
	public void setBoolean(String name, boolean value) throws MException {
		node.setBoolean(name, value);
	}

	@Override
	public void setCalendar(String name, Calendar value) throws MException {
		node.setCalendar(name, value);
	}

	@Override
	public boolean equals(Object obj) {
		return node.equals(obj);
	}

	@Override
	public void setDate(String name, Date value) throws MException {
		node.setDate(name, value);
	}

	@Override
	public void setNumber(String name, Number value) throws MException {
		node.setNumber(name, value);
	}

	@Override
	public Number getNumber(String name, Number def) throws MException {
		return node.getNumber(name, def);
	}

	@Override
	public boolean isProperty(String name) {
		return node.isProperty(name);
	}

	@Override
	public void removeProperty(String key) throws MException {
		node.removeProperty(key);
	}

	@Override
	public void setProperty(String key, Object value) throws MException {
		node.setProperty(key, value);
	}

	@Override
	public boolean isEditable() {
		return node.isEditable();
	}

	@Override
	public Iterator<Entry<String, Object>> iterator() {
		return node.iterator();
	}
	
}
