/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.util;

import de.mhus.lib.core.directory.ClassLoaderDirectory;
import de.mhus.lib.core.directory.DirectoryNode;
import de.mhus.lib.core.directory.MDirectory;
import de.mhus.lib.core.lang.MObject;
import de.mhus.lib.core.util.MNls;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;

public class MNlsFactory
extends MObject {
    private DirectoryNode config;

    public MNlsFactory() {
        this(null);
    }

    public MNlsFactory(DirectoryNode config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MNls create(Object owner) {
        try {
            this.installBase();
            MNls mNls = this.load(null, owner.getClass(), null, null);
            return mNls;
        }
        finally {
            this.leaveBase();
        }
    }

    public MNls load(MDirectory res, Class<?> owner, String resourceName, String locale) {
        try {
            if (resourceName == null) {
                resourceName = owner.getCanonicalName().replace('.', '/');
            }
            if (res == null) {
                res = owner != null ? new ClassLoaderDirectory(owner.getClassLoader()) : new ClassLoaderDirectory();
            }
            if (locale == null) {
                locale = this.getDefaultLocale();
            }
            InputStream is = null;
            Properties properties = new Properties();
            is = res.getInputStream(locale.toString() + "/" + resourceName + ".properties");
            if (is == null) {
                is = res.getInputStream(this.getDefaultLocale() + "/" + resourceName + ".properties");
            }
            if (is == null) {
                is = res.getInputStream(resourceName + ".properties");
            }
            if (is != null) {
                this.log().t("Load Resource", resourceName, locale);
                properties.load(is);
                is.close();
            } else {
                this.log().d("Resource not found", resourceName, locale);
            }
            return new MNls(properties, "");
        }
        catch (Exception e) {
            this.log().info(e);
            return new MNls();
        }
    }

    public String getDefaultLocale() {
        return Locale.getDefault().toString();
    }

    public MNls load(InputStream is) {
        Properties properties = new Properties();
        try {
            properties.load(is);
        }
        catch (IOException e) {
            this.log().i(e);
        }
        return new MNls(properties, "");
    }
}

