/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.pojo;

import de.mhus.lib.core.pojo.PojoAttribute;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public class FunctionAttribute<T>
implements PojoAttribute<T> {
    private Class<T> clazz;
    private Method getter;
    private Method setter;
    private String name;
    private FunctionAttribute<?> parent;

    public FunctionAttribute(Class<T> clazz, Method getter, Method setter, String name, FunctionAttribute<?> parent) {
        this.clazz = clazz;
        this.getter = getter;
        this.setter = setter;
        this.name = name;
        this.parent = parent;
    }

    @Override
    public Class<T> getManagedClass() {
        return this.clazz;
    }

    @Override
    public boolean canRead() {
        return this.getter != null;
    }

    @Override
    public boolean canWrite() {
        return this.setter != null;
    }

    @Override
    public Class<T> getType() {
        if (this.getter != null) {
            return this.getter.getReturnType();
        }
        return this.setter.getParameterTypes()[0];
    }

    @Override
    public void set(Object pojo, T value) throws IOException {
        if (this.parent != null) {
            pojo = this.parent.get(pojo);
        }
        if (this.setter == null) {
            throw new IOException("Method is read only: " + this.getter.getName());
        }
        try {
            this.setter.invoke(pojo, value);
        }
        catch (Exception e) {
            throw new IOException("Error setting to " + this.setter.getName(), e);
        }
    }

    @Override
    public T get(Object pojo) throws IOException {
        if (this.parent != null) {
            pojo = this.parent.get(pojo);
        }
        try {
            return (T)this.getter.invoke(pojo, new Object[0]);
        }
        catch (Exception e) {
            throw new IOException("Error setting to " + this.setter.getName(), e);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<? extends A> annotationClass) {
        A out = this.getter.getAnnotation(annotationClass);
        if (out == null && this.setter != null) {
            out = this.setter.getAnnotation(annotationClass);
        }
        return out;
    }
}

