/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.pojo;

import de.mhus.lib.core.pojo.Action;
import de.mhus.lib.core.pojo.Embedded;
import de.mhus.lib.core.pojo.Hidden;
import de.mhus.lib.core.pojo.PojoAction;
import de.mhus.lib.core.pojo.PojoAttribute;
import de.mhus.lib.core.pojo.PojoFilter;
import de.mhus.lib.core.pojo.PojoModelImpl;

public class DefaultFilter
implements PojoFilter {
    private boolean removeHidden;
    private boolean removeWriteOnly;
    private boolean removeReadOnly;
    private boolean removeEmbedded;
    private boolean removeNoActions;

    public DefaultFilter() {
        this(true, false, true, false, true);
    }

    public DefaultFilter(boolean removeHidden, boolean removeEmbedded, boolean removeWriteOnly, boolean removeReadOnly, boolean removeNoActions) {
        this.removeHidden = removeHidden;
        this.removeEmbedded = removeEmbedded;
        this.removeWriteOnly = removeWriteOnly;
        this.removeReadOnly = removeReadOnly;
        this.removeNoActions = removeNoActions;
    }

    @Override
    public void filter(PojoModelImpl model) {
        for (String name : model.getAttributeNames()) {
            PojoAttribute attr = model.getAttribute(name);
            if (this.removeHidden && attr.getAnnotation(Hidden.class) != null) {
                model.removeAttribute(name);
                continue;
            }
            if (this.removeEmbedded && attr.getAnnotation(Embedded.class) != null) {
                model.removeAttribute(name);
                continue;
            }
            if (this.removeWriteOnly && !attr.canRead()) {
                model.removeAttribute(name);
                continue;
            }
            if (!this.removeReadOnly || attr.canWrite()) continue;
            model.removeAttribute(name);
        }
        for (String name : model.getActionNames()) {
            PojoAction action = model.getAction(name);
            if (!this.removeNoActions || action.getAnnotation(Action.class) != null) continue;
            model.removeAction(name);
        }
    }
}

