/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.logging;

import de.mhus.lib.core.directory.DirectoryNode;
import de.mhus.lib.core.lang.DefaultImplementation;
import de.mhus.lib.core.lang.IBase;
import de.mhus.lib.core.lang.StaticBase;
import de.mhus.lib.core.logging.ConsoleFactory;
import de.mhus.lib.core.logging.Log;
import de.mhus.lib.core.service.ConfigProvider;
import java.util.WeakHashMap;

@DefaultImplementation(value=ConsoleFactory.class)
public abstract class LogFactory
implements IBase {
    WeakHashMap<String, Log> buffer = new WeakHashMap();

    public Log getInstance(Class<?> clazz) {
        return this.getInstance(clazz.getCanonicalName());
    }

    public abstract void init(DirectoryNode var1) throws Exception;

    public void init() throws Exception {
        DirectoryNode config = new StaticBase().base(ConfigProvider.class).getConfig(this, null);
        this.init(config);
    }

    public synchronized Log getInstance(String name) {
        Log inst = this.buffer.get(name);
        if (inst == null) {
            inst = this.createInstance(name);
            this.buffer.put(name, inst);
        }
        return inst;
    }

    public abstract Log createInstance(String var1);

    public Log getLog(Class<?> class1) {
        return this.getInstance(class1);
    }
}

