/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.config;

import de.mhus.lib.core.MCast;
import de.mhus.lib.core.MException;
import de.mhus.lib.core.MXml;
import de.mhus.lib.core.config.IConfig;
import de.mhus.lib.core.directory.DirectoryNode;
import de.mhus.lib.core.directory.WritableDirectoryNode;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.HashSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlConfig
extends IConfig {
    protected Element element;
    protected boolean changed = false;
    protected XmlConfig parent;
    protected String name;

    public XmlConfig() {
        try {
            Document doc = MXml.createDocument();
            this.element = doc.createElement("config");
            if (this.element != null) {
                this.name = this.element.getNodeName();
            }
            doc.appendChild(this.element);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Document getDocument() {
        return this.element.getOwnerDocument();
    }

    public XmlConfig(Element elementByPath) {
        this(null, elementByPath);
    }

    public XmlConfig(XmlConfig parent, Element elementByPath) {
        this.parent = parent;
        this.element = elementByPath;
        if (this.element != null) {
            this.name = this.element.getNodeName();
        }
    }

    public void readConfig(Reader file) throws Exception {
        Document config = MXml.loadXml(file);
        file.close();
        if (this.element != null) {
            this.element = config.getDocumentElement();
        }
        this.name = this.element.getNodeName();
    }

    @Override
    public WritableDirectoryNode getNode(String key) {
        Element e = MXml.getElementByPath(this.element, key);
        if (e == null) {
            return null;
        }
        return new XmlConfig(this, e);
    }

    public WritableDirectoryNode[] getNodes() {
        NodeList list = MXml.getLocalElements(this.element);
        WritableDirectoryNode[] out = new WritableDirectoryNode[list.getLength()];
        for (int i = 0; i < list.getLength(); ++i) {
            out[i] = new XmlConfig(this, (Element)list.item(i));
        }
        return out;
    }

    public WritableDirectoryNode[] getNodes(String key) {
        NodeList list = MXml.getLocalElements(this.element, key);
        WritableDirectoryNode[] out = new WritableDirectoryNode[list.getLength()];
        for (int i = 0; i < list.getLength(); ++i) {
            out[i] = new XmlConfig(this, (Element)list.item(i));
        }
        return out;
    }

    @Override
    public String[] getNodeKeys() {
        NodeList list = MXml.getLocalElements(this.element);
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < list.getLength(); ++i) {
            set.add(list.item(i).getNodeName());
        }
        return set.toArray(new String[set.size()]);
    }

    @Override
    public String[] getPropertyKeys() {
        NamedNodeMap list = this.element.getAttributes();
        String[] out = new String[list.getLength()];
        for (int i = 0; i < list.getLength(); ++i) {
            out[i] = list.item(i).getNodeName();
        }
        return out;
    }

    @Override
    public void removeProperty(String name) {
        this.element.removeAttribute(name);
    }

    @Override
    public void setProperty(String key, Object val) {
        this.element.setAttribute(MXml.normalizeName(key), MCast.objectToString(val));
    }

    public void writeConfig(Writer configStream) throws Exception {
        this.writeConfig(configStream, false);
    }

    public void writeConfig(Writer configStream, boolean intend) throws Exception {
        MXml.trim(this.element);
        MXml.saveXml(this.element, configStream, intend);
    }

    @Override
    public XmlConfig createConfig(String name) {
        Element ele = this.element.getOwnerDocument().createElement(name);
        this.element.appendChild(ele);
        return new XmlConfig(this, ele);
    }

    @Override
    public String getProperty(String key) {
        if (this.element == null || key == null) {
            return null;
        }
        String out = this.element.getAttribute(key);
        if (out == null || out.length() == 0) {
            return null;
        }
        return out;
    }

    @Override
    public boolean isProperty(String name) {
        return this.getProperty(name) != null;
    }

    public boolean isConfigChanged() {
        return this.parent == null ? this.changed : this.changed || this.parent.isConfigChanged();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int moveConfig(DirectoryNode config, int newPos) throws MException {
        Node item;
        int i;
        if (!(config instanceof XmlConfig)) {
            throw new MException(new Object[]{"not a xmlconfig"});
        }
        if (((XmlConfig)config).element.getParentNode() != this.element) {
            throw new MException(new Object[]{"not child of this config"});
        }
        NodeList list = MXml.getLocalElements(this.element);
        if (list.getLength() == 1) {
            if (newPos == -102 || newPos == -103 || newPos == 0) {
                return 0;
            }
            throw new MException(new Object[]{"out of range"});
        }
        if (newPos == -102) {
            this.element.removeChild(((XmlConfig)config).element);
            list = MXml.getLocalElements(this.element);
            this.element.insertBefore(((XmlConfig)config).element, list.item(0));
            return 0;
        }
        if (newPos == -103) {
            this.element.removeChild(((XmlConfig)config).element);
            this.element.appendChild(((XmlConfig)config).element);
            return list.getLength() - 1;
        }
        if (newPos == -101) {
            for (i = 0; i < list.getLength(); ++i) {
                item = list.item(i);
                if (item != ((XmlConfig)config).element) continue;
                if (i == list.getLength() - 1) {
                    throw new MException(new Object[]{"out of range"});
                }
                Node next = list.item(i + 1);
                this.element.removeChild(((XmlConfig)config).element);
                this.element.insertBefore(((XmlConfig)config).element, next);
                return i + 1;
            }
        }
        if (newPos == -100) {
            for (i = 0; i < list.getLength(); ++i) {
                item = list.item(i);
                if (item != ((XmlConfig)config).element) continue;
                if (i == 0) {
                    throw new MException(new Object[]{"out of range"});
                }
                Node before = list.item(i - 1);
                this.element.removeChild(((XmlConfig)config).element);
                this.element.insertBefore(((XmlConfig)config).element, before);
                return i - 1;
            }
        }
        if (newPos < 0 || newPos >= list.getLength()) {
            throw new MException(new Object[]{"out of range"});
        }
        Node before = list.item(newPos);
        if (before == ((XmlConfig)config).element) {
            return newPos;
        }
        this.element.removeChild(((XmlConfig)config).element);
        this.element.insertBefore(((XmlConfig)config).element, before);
        return newPos;
    }

    @Override
    public void removeConfig(DirectoryNode config) throws MException {
        if (!(config instanceof XmlConfig)) {
            throw new MException(new Object[]{"not a xmlconfig"});
        }
        if (((XmlConfig)config).element.getParentNode() != this.element) {
            throw new MException(new Object[]{"not child of this config"});
        }
        this.element.removeChild(((XmlConfig)config).element);
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public WritableDirectoryNode getParent() {
        return this.parent;
    }

    public Element getXmlElement() {
        return this.element;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof XmlConfig) {
            return this.element.equals(((XmlConfig)obj).element);
        }
        return super.equals(obj);
    }

    @Override
    public InputStream getInputStream(String key) {
        return null;
    }
}

