/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.config;

import de.mhus.lib.core.MException;
import de.mhus.lib.core.config.MConfigFactory;
import de.mhus.lib.core.config.PropertiesConfig;
import de.mhus.lib.core.directory.DirectoryNode;
import de.mhus.lib.core.directory.WritableDirectoryNode;
import java.io.File;
import java.io.FileReader;
import java.util.LinkedList;

public class DirConfig
extends PropertiesConfig {
    private File dir;

    public DirConfig(File dir) {
        this.dir = dir;
        File f = new File(dir, "_.properties");
        if (f.exists() && f.isFile()) {
            try {
                FileReader r = new FileReader(f);
                this.readConfig(r);
                r.close();
            }
            catch (Exception e) {
                this.log().d(dir, e);
            }
        }
    }

    @Override
    public String[] getPropertyKeys() {
        return new String[0];
    }

    @Override
    public WritableDirectoryNode getNode(String key) {
        try {
            String keyDot = key + ".";
            for (File f : this.dir.listFiles()) {
                if ((!f.isDirectory() || !f.getName().equals(key)) && (f.isDirectory() || !f.getName().startsWith(keyDot))) continue;
                return this.base(MConfigFactory.class).createConfigFor(f);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public WritableDirectoryNode[] getNodes(String key) {
        LinkedList<WritableDirectoryNode> out = new LinkedList<WritableDirectoryNode>();
        String keyDot = key + ".";
        for (File f : this.dir.listFiles()) {
            try {
                if ((!f.isDirectory() || !f.getName().equals(key)) && (f.isDirectory() || !f.getName().startsWith(keyDot))) continue;
                out.add(this.base(MConfigFactory.class).createConfigFor(f));
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        return out.toArray(new WritableDirectoryNode[out.size()]);
    }

    public WritableDirectoryNode[] getNodes() {
        LinkedList<WritableDirectoryNode> out = new LinkedList<WritableDirectoryNode>();
        for (File f : this.dir.listFiles()) {
            try {
                WritableDirectoryNode conf;
                if (f.isDirectory() && !f.getName().startsWith(".") && !f.isHidden()) {
                    out.add(this.base(MConfigFactory.class).createConfigFor(f));
                    continue;
                }
                if (f.isDirectory() || f.isHidden() || (conf = this.base(MConfigFactory.class).createConfigFor(f)) == null) continue;
                out.add(conf);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        return out.toArray(new WritableDirectoryNode[out.size()]);
    }

    @Override
    public String[] getNodeKeys() {
        LinkedList<String> out = new LinkedList<String>();
        for (File f : this.dir.listFiles()) {
            if (f.isDirectory() && !out.contains(f.getName())) {
                out.add(f.getName());
                continue;
            }
            if (f.isDirectory() || f.getName().startsWith("_")) continue;
            String name = f.getName();
            int pos = name.indexOf(46);
            if (pos > 0) {
                name = name.substring(0, pos);
            }
            if (out.contains(name)) continue;
            out.add(name);
        }
        return out.toArray(new String[out.size()]);
    }

    @Override
    public String getName() {
        return this.dir.getName();
    }

    @Override
    public WritableDirectoryNode createConfig(String key) throws MException {
        return null;
    }

    @Override
    public int moveConfig(DirectoryNode config, int newPos) throws MException {
        return 0;
    }

    @Override
    public void removeConfig(DirectoryNode config) throws MException {
    }

    @Override
    public WritableDirectoryNode getParent() {
        File parent = this.dir.getParentFile();
        if (parent == null) {
            return null;
        }
        return new DirConfig(parent);
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    public File getDirectory() {
        return this.dir;
    }
}

