/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class MSql {
    public static String encode(String string, boolean notNull) {
        if (string == null) {
            return notNull ? "' '" : "NULL";
        }
        if (string.indexOf(39) < 0) {
            return '\'' + string + '\'';
        }
        return '\'' + string.replaceAll("'", "''") + '\'';
    }

    public static String escape(String in) {
        if (in == null) {
            return "";
        }
        if (in.indexOf(39) < 0) {
            return in;
        }
        return in.replaceAll("'", "''");
    }

    public static String unescape(String in) {
        if (in == null) {
            return "";
        }
        if (in.indexOf(39) < 0) {
            return in;
        }
        return in.replaceAll("''", "'");
    }

    public static String escape(String in, int truncateSize) {
        if (in == null) {
            return null;
        }
        if (in.length() > truncateSize) {
            in = in.substring(0, truncateSize);
        }
        if (in.indexOf(39) < 0) {
            return in;
        }
        return in.replaceAll("'", "''");
    }

    public static void executeUpdateQueries(Statement sth, String sql) throws SQLException {
        String[] parts = sql.split(";");
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i].trim().length() == 0) continue;
            sth.executeUpdate(parts[i].trim());
        }
    }

    public static String quoteSQL(String sql) {
        StringBuffer sb = new StringBuffer(sql.length() + 5);
        sb.append('\'');
        for (int i = 0; i < sql.length(); ++i) {
            char c = sql.charAt(i);
            if (c == '\'') {
                sb.append("''");
                continue;
            }
            sb.append(c);
        }
        sb.append('\'');
        return sb.toString();
    }

    public static String toSqlLabel(String in, Connection con) {
        boolean error = false;
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if ((c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_') && (i != 0 || c < '0' || c > '9')) continue;
            error = true;
            break;
        }
        if (!error) {
            return in;
        }
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (i == 0 && c >= '0' && c <= '9') {
                out.append('_');
            }
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_')) {
                out.append('_');
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }
}

