/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core;

import de.mhus.lib.core.MString;
import de.mhus.lib.core.lang.StaticBase;
import java.io.UnsupportedEncodingException;
import java.sql.Date;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public final class MCast {
    protected static StaticBase base = new StaticBase(MCast.class);
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss.SSS z");
    private static DecimalFormat doubleFormat = new DecimalFormat("0.##########");
    private static final byte[] HEX_CHAR_TABLE = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    public static String toCurrencyString(double _in) {
        _in = (double)Math.round(_in * 100.0) / 100.0;
        StringBuffer out = new StringBuffer();
        out.append(_in);
        int pos = out.indexOf(".");
        if (pos >= 0) {
            out.setCharAt(pos, ',');
        } else {
            pos = out.indexOf(",");
        }
        if (pos <= 0) {
            out.append(",00");
        } else if (out.length() - pos <= 2) {
            out.append("0");
        }
        return out.toString();
    }

    public static java.util.Date toDate(String _in, java.util.Date _def) {
        Calendar c = MCast.toCalendar(_in);
        if (c == null) {
            return _def;
        }
        return c.getTime();
    }

    public static Calendar toCalendar(java.util.Date _in) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(_in);
        return calendar;
    }

    public static Calendar toCalendar(java.util.Date _in, TimeZone tz, Locale l) {
        Calendar calendar = Calendar.getInstance(tz, l);
        calendar.setTime(_in);
        return calendar;
    }

    public static Calendar toCalendar(String _in) {
        try {
            String date = _in.trim();
            int hour = 0;
            int min = 0;
            int sec = 0;
            int millies = 0;
            String zone = null;
            char sep = '?';
            if (MString.isIndex(date, '_')) {
                sep = '_';
            } else if (MString.isIndex(date, ' ')) {
                sep = ' ';
            }
            if (sep != '?') {
                String[] parts;
                String time = MString.afterIndex(date, sep).trim();
                date = MString.beforeIndex(_in, sep).trim();
                char sep2 = '?';
                if (MString.isIndex(time, ' ')) {
                    sep2 = ' ';
                } else if (MString.isIndex(time, '_')) {
                    sep2 = '_';
                }
                if (sep2 != '?') {
                    zone = MString.afterIndex(time, sep2);
                    time = MString.beforeIndex(time, sep2);
                }
                if (MString.isIndex(time, '.')) {
                    millies = MCast.toint(MString.afterIndex(time, '.'), 0);
                    time = MString.beforeIndex(time, '.');
                }
                if ((parts = time.split("\\:")).length > 1) {
                    hour = MCast.toint(parts[0], 0);
                    min = MCast.toint(parts[1], 0);
                    if (parts.length > 2) {
                        sec = MCast.toint(parts[2], 0);
                    }
                }
            }
            String[] parts = date.split("-");
            Calendar c = Calendar.getInstance();
            c.clear();
            if (zone != null) {
                TimeZone tz = TimeZone.getTimeZone(zone);
                c.setTimeZone(tz);
            }
            if (parts.length == 3) {
                int year = Integer.parseInt(parts[0]);
                if (parts[0].length() == 2) {
                    year += 2000;
                }
                int month = Integer.parseInt(parts[1]) - 1;
                int day = Integer.parseInt(parts[2]);
                c.set(year, month, day);
            } else if (parts.length == 2) {
                c.set(2, Integer.parseInt(parts[0]) - 1);
                c.set(5, Integer.parseInt(parts[1]));
            } else {
                parts = date.split("\\.");
                if (parts.length == 3) {
                    int year = Integer.parseInt(parts[2]);
                    if (parts[2].length() == 2) {
                        year += 2000;
                    }
                    int month = Integer.parseInt(parts[1]) - 1;
                    int day = Integer.parseInt(parts[0]);
                    c.set(year, month, day);
                } else if (parts.length == 2) {
                    int year = Integer.parseInt(parts[1]);
                    if (parts[1].length() == 2) {
                        year += 2000;
                    }
                    int month = Integer.parseInt(parts[0]) - 1;
                    c.set(2, month);
                    c.set(1, year);
                } else {
                    parts = date.split("/");
                    if (parts.length == 3) {
                        c.set(Integer.parseInt(parts[2]), Integer.parseInt(parts[0]) - 1, Integer.parseInt(parts[1]));
                    }
                    if (parts.length == 2) {
                        c.set(2, Integer.parseInt(parts[0]) - 1);
                        c.set(1, Integer.parseInt(parts[1]));
                    }
                }
            }
            c.set(11, hour);
            c.set(12, min);
            c.set(14, sec * 1000 + millies);
            return c;
        }
        catch (Throwable e) {
            base.log().t(_in, e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(java.util.Date _in) {
        if (_in == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = dateFormat;
        synchronized (simpleDateFormat) {
            return dateFormat.format(_in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(Calendar _in) {
        if (_in == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = dateFormat;
        synchronized (simpleDateFormat) {
            return dateFormat.format(_in.getTime());
        }
    }

    public static String toIsoDate(java.util.Date _in) {
        Calendar c = Calendar.getInstance();
        c.setTime(_in);
        return MCast.toIsoDate(c);
    }

    public static String toIsoDateTime(java.util.Date _in) {
        Calendar c = Calendar.getInstance();
        c.setTime(_in);
        return MCast.toIsoDateTime(c);
    }

    public static String toBinaryString(byte[] in) throws UnsupportedEncodingException {
        byte[] hex = new byte[2 * in.length];
        int index = 0;
        for (byte b : in) {
            int v = b & 0xFF;
            hex[index++] = HEX_CHAR_TABLE[v >>> 4];
            hex[index++] = HEX_CHAR_TABLE[v & 0xF];
        }
        return new String(hex, "ASCII");
    }

    public static byte[] fromBinaryString(String in) {
        byte[] out = new byte[in.length() / 2];
        for (int i = 0; i < out.length; ++i) {
            out[i] = MCast.byteFromHex(in, i * 2);
        }
        return out;
    }

    public static byte byteFromHex(String in, int offset) {
        int i = Integer.parseInt(in.substring(offset, offset + 2), 16);
        byte b = (byte)(i & 0xFF);
        return b;
    }

    public static String toHex2String(byte in) throws UnsupportedEncodingException {
        byte[] hex = new byte[2];
        int v = in & 0xFF;
        hex[0] = HEX_CHAR_TABLE[v >>> 4];
        hex[1] = HEX_CHAR_TABLE[v & 0xF];
        return new String(hex, "ASCII");
    }

    public static String toIsoDateTime(Calendar _in) {
        return _in.get(1) + "-" + MCast.toString(_in.get(2) + 1, 2) + "-" + MCast.toString(_in.get(5), 2) + " " + MCast.toString(_in.get(11), 2) + ":" + MCast.toString(_in.get(12), 2) + ":" + MCast.toString(_in.get(13), 2);
    }

    public static String toIsoDateTime(long timeStamp) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(timeStamp);
        return MCast.toIsoDateTime(c);
    }

    public static String toIsoDate(Calendar _in) {
        return _in.get(1) + "-" + MCast.toString(_in.get(2) + 1, 2) + "-" + MCast.toString(_in.get(5), 2);
    }

    public static boolean toboolean(Object _in, boolean _default) {
        if (_in == null) {
            return _default;
        }
        if (_in instanceof Boolean) {
            return (Boolean)_in;
        }
        if (_in instanceof Number) {
            return ((Number)_in).intValue() != 0;
        }
        String in = _in.toString().toLowerCase().trim();
        if (in.equals("yes")) {
            return true;
        }
        if (in.equals("on")) {
            return true;
        }
        if (in.equals("true")) {
            return true;
        }
        if (in.equals("ja")) {
            return true;
        }
        if (in.equals("tak")) {
            return true;
        }
        if (in.equals("1")) {
            return true;
        }
        if (in.equals("t")) {
            return true;
        }
        if (in.equals("y")) {
            return true;
        }
        if (in.equals("no")) {
            return false;
        }
        if (in.equals("off")) {
            return false;
        }
        if (in.equals("false")) {
            return false;
        }
        if (in.equals("nein")) {
            return false;
        }
        if (in.equals("nie")) {
            return false;
        }
        if (in.equals("0")) {
            return false;
        }
        if (in.equals("-1")) {
            return false;
        }
        if (in.equals("f")) {
            return false;
        }
        if (in.equals("n")) {
            return false;
        }
        return _default;
    }

    public static float tofloat(Object _in, float _def) {
        if (_in == null) {
            return _def;
        }
        if (_in instanceof Number) {
            return ((Number)_in).floatValue();
        }
        try {
            return Float.parseFloat(String.valueOf(_in));
        }
        catch (Throwable e) {
            base.log().t(_in, e.toString());
            return _def;
        }
    }

    public static double todouble(Object _in, double _def) {
        if (_in == null) {
            return _def;
        }
        if (_in instanceof Number) {
            return ((Number)_in).doubleValue();
        }
        try {
            return Double.parseDouble(String.valueOf(_in));
        }
        catch (Throwable e) {
            base.log().t(_in, e.toString());
            return _def;
        }
    }

    public static int toint(Object in, int _def) {
        if (in == null) {
            return _def;
        }
        if (in instanceof Number) {
            return ((Number)in).intValue();
        }
        String _in = String.valueOf(in);
        try {
            if (_in.startsWith("0x")) {
                int out = 0;
                for (int i = 2; i < _in.length(); ++i) {
                    int s = -1;
                    char c = _in.charAt(i);
                    if (c >= '0' && c <= '9') {
                        s = c - 48;
                    } else if (c >= 'a' && c <= 'f') {
                        s = c - 97 + 10;
                    } else if (c >= 'A' && c <= 'F') {
                        s = c - 65 + 10;
                    }
                    if (s == -1) {
                        throw new NumberFormatException(_in);
                    }
                    out = out * 16 + s;
                }
                return out;
            }
            return Integer.parseInt(_in);
        }
        catch (Throwable e) {
            base.log().t(_in, e.toString());
            return _def;
        }
    }

    public static long tolong(Object in, long _def) {
        if (in == null) {
            return _def;
        }
        if (in instanceof Number) {
            return ((Number)in).longValue();
        }
        String _in = String.valueOf(in);
        try {
            if (_in.startsWith("0x")) {
                long out = 0L;
                for (int i = 2; i < _in.length(); ++i) {
                    int s = -1;
                    char c = _in.charAt(i);
                    if (c >= '0' && c <= '9') {
                        s = c - 48;
                    } else if (c >= 'a' && c <= 'f') {
                        s = c - 97 + 10;
                    } else if (c >= 'A' && c <= 'F') {
                        s = c - 65 + 10;
                    }
                    if (s == -1) {
                        throw new NumberFormatException(_in);
                    }
                    out = out * 16L + (long)s;
                }
                return out;
            }
            return Long.parseLong(_in);
        }
        catch (Throwable e) {
            base.log().t(_in, e.toString());
            return _def;
        }
    }

    public static String toString(double _in) {
        String out = doubleFormat.format(_in);
        if (out.indexOf(44) >= 0) {
            out = out.replace(",", ".");
        }
        return out;
    }

    public static String toString(float _in) {
        return Float.toString(_in).replace(",", ".");
    }

    public static String toString(boolean _in) {
        if (_in) {
            return "true";
        }
        return "false";
    }

    public static String toString(int _in) {
        return Integer.toString(_in);
    }

    public static String toString(int _in, int _digits) {
        String out = Integer.toString(_in);
        while (out.length() < _digits) {
            out = "0" + out;
        }
        return out;
    }

    public static String toString(long _in) {
        return String.valueOf(_in);
    }

    public static String toHex2String(int _in) {
        String out = Integer.toHexString(_in).toUpperCase();
        if (out.length() == 1) {
            out = "0" + out;
        }
        return out;
    }

    public static String toHex4String(int _in) {
        return MCast.toHex2String(_in / 256) + MCast.toHex2String(_in % 256);
    }

    public static String[] toStringArray(List<?> _v) {
        String[] out = new String[_v.size()];
        for (int i = 0; i < _v.size(); ++i) {
            Object o = _v.get(i);
            out[i] = o == null ? null : o.toString();
        }
        return out;
    }

    public static int tointFromHex(String _in) {
        int out = 0;
        for (int i = 0; i < _in.length(); ++i) {
            int x = 0;
            char c = _in.charAt(i);
            if (c >= '0' && c <= '9') {
                x = c - 48;
            } else if (c >= 'a' && c <= 'f') {
                x = c - 97 + 10;
            } else if (c >= 'A' && c <= 'F') {
                x = c - 65 + 10;
            } else {
                throw new NumberFormatException(_in);
            }
            out = out * 16 + x;
        }
        return out;
    }

    public static String toString(byte[] in) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < in.length; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(Byte.toString(in[i]));
        }
        return sb.toString();
    }

    public static byte[] toByteArray(String in) {
        if (in.length() == 0) {
            return new byte[0];
        }
        int offset = 0;
        int cnt = 0;
        while ((offset = in.indexOf(44, offset + 1)) >= 0) {
            ++cnt;
        }
        offset = 0;
        int old = 0;
        byte[] out = new byte[cnt + 1];
        cnt = 0;
        while ((offset = in.indexOf(44, offset + 1)) >= 0) {
            out[cnt] = Byte.parseByte(in.substring(old, offset));
            ++cnt;
            old = offset + 1;
        }
        out[cnt] = Byte.parseByte(in.substring(old));
        return out;
    }

    public static String toString(String firstLine, StackTraceElement[] trace) {
        StringBuffer sb = new StringBuffer();
        if (firstLine != null) {
            sb.append(firstLine).append('\n');
        }
        if (trace == null) {
            return sb.toString();
        }
        for (int i = 0; i < trace.length; ++i) {
            sb.append("\tat ").append(trace[i].getClassName()).append('.').append(trace[i].getMethodName()).append('(').append(trace[i].getFileName()).append(':').append(trace[i].getLineNumber()).append(")\n");
        }
        return sb.toString();
    }

    public static Map<String, Object> toIndexedMap(Object ... values) {
        HashMap<String, Object> out = new HashMap<String, Object>();
        for (int i = 0; i < values.length; ++i) {
            out.put(MCast.toString(i), values[i]);
        }
        return out;
    }

    public static String objectToString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return MCast.toString((Integer)value);
        }
        if (value instanceof Long) {
            return MCast.toString((Long)value);
        }
        if (value instanceof Double) {
            return MCast.toString((Double)value);
        }
        if (value instanceof Float) {
            return MCast.toString(((Float)value).floatValue());
        }
        if (value instanceof java.util.Date) {
            return MCast.toString((java.util.Date)value);
        }
        if (value instanceof Calendar) {
            return MCast.toString((Calendar)value);
        }
        return value.toString();
    }

    public static java.util.Date objectToDate(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof java.util.Date) {
            return (java.util.Date)value;
        }
        if (value instanceof Calendar) {
            return ((Calendar)value).getTime();
        }
        return MCast.toDate(String.valueOf(value), null);
    }

    public static Date toSqlDate(Date date) {
        return new Date(date.getTime());
    }
}

