/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.tests.docker;

import de.mhus.lib.core.MSystem;
import de.mhus.lib.tests.docker.ContainerBuilder;
import de.mhus.lib.tests.docker.DockerContainer;
import java.io.File;

public class Karaf
extends DockerContainer {
    public Karaf(String name, String version, String ... params) {
        super(name, "mhus/apache-karaf:" + (version == null ? "4.2.6_04" : version), params);
    }

    @Override
    protected boolean buildConfigParam(ContainerBuilder config, String param) {
        if (param.equals("debug")) {
            Object m2home = System.getenv("KARAF_M2_HOME");
            if (m2home == null) {
                m2home = MSystem.getUserHome() + File.separator + ".m2";
            }
            config.volumes.add((String)m2home + ":/home/user/.m2");
            config.cmd.add("debug");
            config.ports.add("15005+:5005");
            return true;
        }
        return false;
    }

    @Override
    protected void buildConfig(ContainerBuilder config) {
        super.buildConfig(config);
        config.builder.withTty(Boolean.valueOf(true));
        config.builder.withStdinOpen(Boolean.valueOf(true));
        config.builder.withAttachStdout(Boolean.valueOf(true));
        config.builder.withAttachStderr(Boolean.valueOf(true));
    }
}

