/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.tests.docker;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.AttachContainerCmd;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.CreateNetworkResponse;
import com.github.dockerjava.api.command.ExecCreateCmd;
import com.github.dockerjava.api.command.ExecCreateCmdResponse;
import com.github.dockerjava.api.command.ExecStartCmd;
import com.github.dockerjava.api.command.LogContainerCmd;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.exception.NotModifiedException;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.api.model.Network;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.DockerClientImpl;
import com.github.dockerjava.httpclient5.ApacheDockerHttpClient;
import com.github.dockerjava.transport.DockerHttpClient;
import com.github.dockerjava.transport.SSLConfig;
import de.mhus.lib.core.MCollection;
import de.mhus.lib.core.MPeriod;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.MThread;
import de.mhus.lib.core.mapi.DockerInitializer;
import de.mhus.lib.tests.docker.DockerContainer;
import de.mhus.lib.tests.docker.LogStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class DockerScenario {
    private LinkedList<DockerContainer> containers = new LinkedList();
    private DockerClient docker;
    private String prefix = "test-";
    private Timer watch = new Timer("DockerScenarioTimer", true);
    private String networkId;
    private boolean useExistingNetwork = true;
    private int cnt;

    public DockerScenario() {
    }

    public DockerScenario(String prefix) {
        this.prefix = prefix;
    }

    public DockerScenario add(String name, String image, String ... params) {
        return this.add(new DockerContainer(name, image, params));
    }

    public DockerScenario add(DockerContainer inst) {
        this.containers.add(inst);
        return this;
    }

    public DockerContainer get(String name) throws de.mhus.lib.errors.NotFoundException {
        for (DockerContainer inst : this.containers) {
            if (!inst.getName().equals(name)) continue;
            return inst;
        }
        throw new de.mhus.lib.errors.NotFoundException("container not found", new Object[]{name});
    }

    public void init() {
        if (this.docker == null) {
            if (System.getenv("DOCKER_HOST") == null) {
                System.clearProperty("http.proxyHost");
                System.clearProperty("https.proxyHost");
                System.clearProperty("ftp.proxyHost");
            }
            DefaultDockerClientConfig config = DefaultDockerClientConfig.createDefaultConfigBuilder().build();
            ApacheDockerHttpClient httpClient = new ApacheDockerHttpClient.Builder().dockerHost(config.getDockerHost()).sslConfig((SSLConfig)config.getSSLConfig()).build();
            this.docker = DockerClientImpl.getInstance((DockerClientConfig)config, (DockerHttpClient)httpClient);
        }
    }

    public void start() throws InterruptedException {
        this.init();
        this.destroy();
        this.destroyNetwork(false);
        this.createNetwork();
        for (DockerContainer cont : this.containers) {
            System.out.println("--- Create " + cont.getName());
            try {
                this.docker.inspectImageCmd(cont.getImage()).exec();
            }
            catch (NotFoundException e) {
                System.out.println("    Load: " + cont.getImage());
                this.docker.pullImageCmd(cont.getImage()).start().awaitCompletion();
            }
            CreateContainerCmd containerCmd = this.docker.createContainerCmd(cont.getImage());
            cont.buildConfig(this, containerCmd);
            containerCmd.withName(this.prefix + cont.getName());
            CreateContainerResponse resp = containerCmd.exec();
            cont.setId(this, resp.getId());
            for (String warning : resp.getWarnings()) {
                System.out.println("    " + warning);
            }
        }
        for (DockerContainer cont : this.containers) {
            this.docker.connectToNetworkCmd().withContainerId(cont.getId()).withNetworkId(this.networkId).exec();
        }
        for (DockerContainer cont : this.containers) {
            System.out.println("--- Start " + cont.getName() + " " + cont.getId());
            this.docker.startContainerCmd(cont.getId()).exec();
        }
    }

    public void createNetwork() {
        String nameNet = (this.prefix + "net").replace("-", "_");
        if (this.useExistingNetwork) {
            for (Network network : (List)this.docker.listNetworksCmd().exec()) {
                if (!network.getName().equals(nameNet)) continue;
                this.networkId = network.getId();
                return;
            }
        }
        System.out.println("--- CreateNetwork " + nameNet);
        Network.Ipam ipam = new Network.Ipam().withConfig(new Network.Ipam.Config[]{new Network.Ipam.Config().withSubnet("10.67.79.0/24").withGateway("10.67.79.1")});
        HashMap<String, String> optionsNet = new HashMap<String, String>();
        optionsNet.put("com.docker.network.bridge.name", nameNet);
        optionsNet.put("com.docker.network.bridge.host_binding_ipv4", "0.0.0.0");
        optionsNet.put("com.docker.network.bridge.enable_icc", "true");
        optionsNet.put("com.docker.network.bridge.enable_ip_masquerade", "true");
        optionsNet.put("com.docker.network.driver.mtu", "1500");
        CreateNetworkResponse resNet = (CreateNetworkResponse)this.docker.createNetworkCmd().withName(nameNet).withIpam(ipam).exec();
        if (resNet.getWarnings() != null) {
            for (String warning : resNet.getWarnings()) {
                System.out.println("    " + warning);
            }
        }
        this.networkId = resNet.getId();
    }

    public void destroyNetwork(boolean forced) {
        if (this.useExistingNetwork && !forced) {
            return;
        }
        this.init();
        if (this.networkId != null) {
            try {
                this.docker.removeNetworkCmd(this.networkId).exec();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.networkId = null;
        }
        String nameNet = (this.prefix + "net").replace("-", "_");
        for (Network network : (List)this.docker.listNetworksCmd().exec()) {
            if (!network.getName().equals(nameNet)) continue;
            this.networkId = network.getId();
            break;
        }
        if (this.networkId != null) {
            try {
                this.docker.removeNetworkCmd(this.networkId).exec();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.networkId = null;
        }
    }

    public void destroyPrefix() {
        this.init();
        ArrayList<String> remove = new ArrayList<String>();
        for (Container cont : (List)this.docker.listContainersCmd().withShowAll(Boolean.valueOf(true)).exec()) {
            String removeName = null;
            for (String name : cont.getNames()) {
                if (!name.startsWith("/" + this.prefix)) continue;
                removeName = name;
                break;
            }
            if (removeName == null) continue;
            System.out.println("--- Stop " + removeName);
            remove.add(cont.getId());
            try {
                this.docker.stopContainerCmd(cont.getId()).withTimeout(Integer.valueOf(60)).exec();
            }
            catch (NotModifiedException notModifiedException) {}
        }
        for (String id : remove) {
            System.out.println("--- Remove " + id);
            this.docker.removeContainerCmd(id).exec();
        }
        for (DockerContainer cont2 : this.containers) {
            cont2.setId(this, null);
        }
        this.destroyNetwork(false);
    }

    public void destroy() {
        this.init();
        this.fetchContainers();
        ArrayList<DockerContainer> reverse = new ArrayList<DockerContainer>(this.containers);
        ArrayList<String> remove = new ArrayList<String>();
        Collections.reverse(reverse);
        for (DockerContainer cont : reverse) {
            if (cont.getId() == null) continue;
            System.out.println("--- Stop " + cont.getName());
            remove.add(cont.getId());
            try {
                if (!cont.isRunning()) continue;
                this.docker.stopContainerCmd(cont.getId()).withTimeout(Integer.valueOf(60)).exec();
            }
            catch (NotModifiedException notModifiedException) {}
        }
        for (DockerContainer cont : reverse) {
            while (cont.isRunning()) {
                System.out.println("--- Running " + cont.getName());
                MThread.sleep((long)200L);
            }
            System.out.println("--- Done " + cont.getName());
            cont.setId(this, null);
        }
        for (String id : remove) {
            System.out.println("--- Remove " + id);
            this.docker.removeContainerCmd(id).exec();
        }
    }

    public LogStream exec1(String name, String ... cmd) throws InterruptedException, de.mhus.lib.errors.NotFoundException {
        return this.exec(name, cmd, null, false, null, null, null);
    }

    public LogStream exec(String name, String cmd) throws InterruptedException, de.mhus.lib.errors.NotFoundException {
        return this.exec(name, cmd.split(" "), null, false, null, null, null);
    }

    public LogStream exec(String name, String cmd, String send) throws InterruptedException, de.mhus.lib.errors.NotFoundException {
        return this.exec(name, cmd.split(" "), null, false, null, null, send);
    }

    public LogStream exec(String name, String[] cmd, List<String> env, boolean privileges, String user, String dir, String send) throws InterruptedException, de.mhus.lib.errors.NotFoundException {
        DockerContainer cont = this.get(name);
        if (cont.getId() == null) {
            throw new de.mhus.lib.errors.NotFoundException("Container not started", new Object[]{cont.getName()});
        }
        LogStream stream = new LogStream(cont);
        return this.exec(stream, cmd, env, privileges, user, dir, send);
    }

    public LogStream exec(LogStream stream, String[] cmd, List<String> env, boolean privileges, String user, String dir, String send) throws InterruptedException, de.mhus.lib.errors.NotFoundException {
        DockerContainer cont = stream.getContainer();
        ExecCreateCmd builder = this.docker.execCreateCmd(cont.getId()).withAttachStderr(Boolean.valueOf(true)).withAttachStdout(Boolean.valueOf(true)).withTty(Boolean.valueOf(true));
        builder.withCmd(cmd);
        if (send != null) {
            builder.withAttachStdin(Boolean.valueOf(true));
        }
        if (env != null) {
            builder.withEnv(env);
        }
        if (privileges) {
            builder.withPrivileged(Boolean.valueOf(true));
        }
        if (user != null) {
            builder.withUser(user);
        }
        if (dir != null) {
            builder.withWorkingDir(dir);
        }
        ExecCreateCmdResponse create = (ExecCreateCmdResponse)builder.exec();
        ExecStartCmd startBuilder = this.docker.execStartCmd(create.getId());
        if (send != null) {
            ByteArrayInputStream is = new ByteArrayInputStream(send.getBytes(MString.CHARSET_CHARSET_UTF_8));
            startBuilder.withStdIn((InputStream)is);
        }
        startBuilder.exec((ResultCallback)stream);
        return stream;
    }

    public LogStream attach(String name, String send) throws InterruptedException, de.mhus.lib.errors.NotFoundException {
        DockerContainer cont = this.get(name);
        if (cont.getId() == null) {
            throw new de.mhus.lib.errors.NotFoundException("Container not started", new Object[]{cont.getName()});
        }
        LogStream stream = new LogStream(cont);
        return this.attach(stream, send);
    }

    public LogStream attach(LogStream stream, String send) throws InterruptedException, de.mhus.lib.errors.NotFoundException {
        DockerContainer cont = stream.getContainer();
        AttachContainerCmd builder = this.docker.attachContainerCmd(cont.getId()).withStdErr(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true)).withFollowStream(Boolean.valueOf(true));
        if (send != null) {
            ByteArrayInputStream is = new ByteArrayInputStream(send.getBytes(MString.CHARSET_CHARSET_UTF_8));
            builder.withStdIn((InputStream)is);
        }
        builder.exec((ResultCallback)stream);
        stream.awaitStarted(60L, TimeUnit.SECONDS);
        return stream;
    }

    public LogStream logs(String name, boolean follow, int tail) throws de.mhus.lib.errors.NotFoundException {
        DockerContainer cont = this.get(name);
        if (cont.getId() == null) {
            throw new de.mhus.lib.errors.NotFoundException("Container not started", new Object[]{cont.getName()});
        }
        LogStream stream = new LogStream(cont);
        return this.logs(stream, follow, tail);
    }

    public LogStream logs(LogStream stream, boolean follow, int tail) throws de.mhus.lib.errors.NotFoundException {
        DockerContainer cont = stream.getContainer();
        LogContainerCmd lcc = this.docker.logContainerCmd(cont.getId());
        lcc.withStdErr(Boolean.valueOf(true));
        lcc.withStdOut(Boolean.valueOf(true));
        lcc.withFollowStream(Boolean.valueOf(follow));
        if (tail > 0) {
            lcc.withTail(Integer.valueOf(tail));
        }
        lcc.exec((ResultCallback)stream);
        return stream;
    }

    public void waitForLogEntry(String name, String waitForString, int tail) throws de.mhus.lib.errors.NotFoundException, IOException, InterruptedException {
        try (LogStream logStream = this.logs(name, true, tail);){
            logStream.awaitStarted(60L, TimeUnit.SECONDS);
            this.waitForLogEntry(logStream, waitForString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForLog(long timeout, long sleep, final LogStream logStream, Function<String, Boolean> check) throws de.mhus.lib.errors.NotFoundException, IOException {
        final WaitContainer waitCont = new WaitContainer();
        waitCont.cont = logStream.getContainer();
        StringBuilder content = new StringBuilder();
        if (waitCont.cont.getId() == null) {
            throw new de.mhus.lib.errors.NotFoundException("Container not started", new Object[]{waitCont.cont.getName()});
        }
        this.watch.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    if (!waitCont.running) {
                        this.cancel();
                    } else if (!waitCont.cont.isRunning()) {
                        System.err.println("#### CLOSE " + waitCont.cont.getName() + " ####");
                        logStream.close();
                        this.cancel();
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }, 1000L, 1000L);
        try {
            long start = System.currentTimeMillis();
            while (!MPeriod.isTimeOut((long)start, (long)timeout)) {
                String logStr = logStream.readLine();
                content.append(logStr);
                if (check.apply(content.toString()).booleanValue()) {
                    boolean bl = true;
                    return bl;
                }
                if (!logStream.isClosed()) continue;
                throw new EOFException();
            }
        }
        finally {
            waitCont.running = false;
        }
        return false;
    }

    public void waitForLogEntry(final LogStream logStream, String waitForString) throws de.mhus.lib.errors.NotFoundException, IOException {
        final WaitContainer waitCont = new WaitContainer();
        waitCont.cont = logStream.getContainer();
        if (waitCont.cont.getId() == null) {
            throw new de.mhus.lib.errors.NotFoundException("Container not started", new Object[]{waitCont.cont.getName()});
        }
        this.watch.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    if (!waitCont.running) {
                        this.cancel();
                    } else if (!waitCont.cont.isRunning()) {
                        System.err.println("#### CLOSE " + waitCont.cont.getName() + " ####");
                        logStream.close();
                        this.cancel();
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }, 1000L, 1000L);
        try {
            do {
                String logStr;
                if (!(logStr = logStream.readLine()).contains(waitForString)) continue;
                return;
            } while (!logStream.isClosed());
            throw new EOFException();
        }
        finally {
            waitCont.running = false;
        }
    }

    private void fetchContainers() {
        for (DockerContainer cont2 : this.containers) {
            cont2.setId(this, null);
        }
        for (Container cont : (List)this.docker.listContainersCmd().withShowAll(Boolean.valueOf(true)).exec()) {
            for (DockerContainer cont2 : this.containers) {
                if (!MCollection.contains((Object[])cont.getNames(), (Object)("/" + this.prefix + cont2.getName()))) continue;
                cont2.setId(this, cont.getId());
            }
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public DockerClient getClient() {
        return this.docker;
    }

    public boolean isUseExistingNetwork() {
        return this.useExistingNetwork;
    }

    public DockerScenario setUseExistingNetwork(boolean useExistingNetwork) {
        this.useExistingNetwork = useExistingNetwork;
        return this;
    }

    String getExternalHost() {
        if (System.getenv("DOCKER_HOST") == null) {
            return "localhost";
        }
        return System.getenv("DOCKER_HOST");
    }

    boolean isDockerInDockerMode() {
        if (System.getenv("DOCKER_MODE") == null) {
            return DockerInitializer.isDockerEnabled();
        }
        return "DOCKER".equals(System.getenv("DOCKER_MODE"));
    }

    public int cnt() {
        return this.cnt++;
    }

    private static class WaitContainer {
        public DockerContainer cont;
        volatile boolean running = true;

        private WaitContainer() {
        }
    }
}

