/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.tests.docker;

import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.Ports;
import de.mhus.lib.core.M;
import de.mhus.lib.core.MString;
import de.mhus.lib.tests.docker.ContainerBuilder;
import de.mhus.lib.tests.docker.DockerScenario;
import java.util.Map;

public class DockerContainer {
    private String name;
    private String image;
    private String id;
    private String[] params;
    private DockerScenario scenario;

    public DockerContainer(String name, String image, String ... params) {
        this.name = name;
        this.image = image;
        this.params = params;
    }

    public String getName() {
        return this.name;
    }

    public String getImage() {
        return this.image;
    }

    public String getId() {
        return this.id;
    }

    public void setId(DockerScenario scenario, String id) {
        this.scenario = scenario;
        this.id = id;
    }

    public void buildConfig(DockerScenario scenario, CreateContainerCmd builder) {
        builder.withHostName(this.name);
        builder.withImage(this.image);
        ContainerBuilder config = new ContainerBuilder(scenario, this, builder);
        this.buildConfig(config);
        config.build();
    }

    protected void buildConfig(ContainerBuilder config) {
        if (this.params == null) {
            return;
        }
        for (String param : this.params) {
            if (param.equals("privileged")) {
                config.hostBuilder.withPrivileged(Boolean.valueOf(true));
                continue;
            }
            if (param.startsWith("user:")) {
                config.builder.withUser(MString.afterIndex((String)param, (char)':'));
                continue;
            }
            if (param.startsWith("env:") || param.startsWith("e:")) {
                config.env.add(MString.afterIndex((String)param, (char)':'));
                continue;
            }
            if (param.startsWith("vol:") || param.startsWith("v:") || param.startsWith("volume:")) {
                config.volumes.add(MString.afterIndex((String)param, (char)':'));
                continue;
            }
            if (param.startsWith("t") || param.equals("tty")) {
                config.builder.withTty(Boolean.valueOf(true));
                continue;
            }
            if (param.startsWith("i") || param.equals("interactive")) {
                config.builder.withStdinOpen(Boolean.valueOf(true));
                config.builder.withAttachStdout(Boolean.valueOf(true));
                config.builder.withAttachStderr(Boolean.valueOf(true));
                continue;
            }
            if (param.startsWith("link:") || param.startsWith("l:")) {
                config.links.add(config.scenario.getPrefix() + MString.afterIndex((String)param, (char)':'));
                continue;
            }
            if (param.startsWith("port:") || param.startsWith("p:")) {
                config.ports.add(MString.afterIndex((String)param, (char)':'));
                continue;
            }
            if (param.startsWith("cmd:")) {
                config.cmd.add(MString.afterIndex((String)param, (char)':'));
                continue;
            }
            if (param.startsWith("entrypoint:")) {
                config.entrypoint.add(MString.afterIndex((String)param, (char)':'));
                continue;
            }
            if (this.buildConfigParam(config, param)) continue;
            System.out.println("*** Unknown param: " + param);
        }
    }

    protected boolean buildConfigParam(ContainerBuilder config, String param) {
        return false;
    }

    public boolean isRunning() {
        if (this.scenario == null || this.id == null) {
            return false;
        }
        try {
            InspectContainerResponse resp = this.scenario.getClient().inspectContainerCmd(this.getId()).exec();
            return resp.getState().getRunning();
        }
        catch (NotFoundException e) {
            e.printStackTrace();
            this.id = null;
            return false;
        }
    }

    public int getPortBinding(int exposed) {
        if (this.scenario.isDockerInDockerMode()) {
            return exposed;
        }
        for (Map.Entry binding : this.scenario.getClient().inspectContainerCmd(this.id).exec().getNetworkSettings().getPorts().getBindings().entrySet()) {
            if (((ExposedPort)binding.getKey()).getPort() != exposed || ((Ports.Binding[])binding.getValue()).length <= 0) continue;
            return M.to((Object)((Ports.Binding[])binding.getValue())[0].getHostPortSpec(), (int)0);
        }
        return 0;
    }

    public String getExternalHost() {
        if (this.scenario.isDockerInDockerMode()) {
            return this.scenario.getClient().inspectContainerCmd(this.id).exec().getNetworkSettings().getIpAddress();
        }
        return this.scenario.getExternalHost();
    }
}

