/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.tests.docker;

import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.model.AccessMode;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.Link;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.api.model.Volume;
import de.mhus.lib.core.M;
import de.mhus.lib.core.MNet;
import de.mhus.lib.core.MString;
import de.mhus.lib.errors.MRuntimeException;
import de.mhus.lib.tests.docker.DockerContainer;
import de.mhus.lib.tests.docker.DockerScenario;
import java.util.LinkedList;

public class ContainerBuilder {
    public final DockerScenario scenario;
    public final DockerContainer cont;
    public final LinkedList<String> links = new LinkedList();
    public final LinkedList<String> cmd = new LinkedList();
    public final LinkedList<String> env = new LinkedList();
    public final LinkedList<String> entrypoint = new LinkedList();
    public final LinkedList<String> volumes = new LinkedList();
    public final LinkedList<String> ports = new LinkedList();
    public final HostConfig hostBuilder;
    public final CreateContainerCmd builder;
    public final LinkedList<Volume> volumesDef = new LinkedList();
    public final LinkedList<Bind> volumesBind = new LinkedList();
    public final LinkedList<PortBinding> portConfig = new LinkedList();
    public final LinkedList<Link> linksBind = new LinkedList();
    public final LinkedList<ExposedPort> exposedPorts = new LinkedList();

    public ContainerBuilder(DockerScenario scenario, DockerContainer cont, CreateContainerCmd builder) {
        this.scenario = scenario;
        this.builder = builder;
        this.cont = cont;
        this.hostBuilder = HostConfig.newHostConfig();
    }

    public void build() {
        if (this.ports.size() > 0) {
            for (String port : this.ports) {
                PortBinding ports;
                if (port.endsWith("/udp")) {
                    ExposedPort udp;
                    if ((port = MString.beforeIndex((String)port, (char)'/')).indexOf(58) > 0) {
                        udp = ExposedPort.udp((int)M.to((Object)MString.afterIndex((String)port, (char)':'), (int)0));
                        Ports.Binding bind = Ports.Binding.bindPort((int)M.to((Object)MString.beforeIndex((String)port, (char)':'), (int)0));
                        PortBinding ports2 = new PortBinding(bind, udp);
                        this.exposedPorts.add(udp);
                        this.portConfig.add(ports2);
                        continue;
                    }
                    udp = ExposedPort.udp((int)M.to((Object)port, (int)0));
                    ports = new PortBinding(Ports.Binding.empty(), udp);
                    this.exposedPorts.add(udp);
                    this.portConfig.add(ports);
                    continue;
                }
                if (port.endsWith("/tcp")) {
                    port = MString.beforeIndex((String)port, (char)'/');
                }
                if (port.indexOf(58) > 0) {
                    String bindPort = MString.beforeIndex((String)port, (char)':');
                    if (bindPort.endsWith("+")) {
                        int start = M.to((Object)bindPort.substring(0, bindPort.length() - 1), (int)0);
                        if ((start += this.scenario.cnt()) == 0) {
                            throw new MRuntimeException(415, "port {1} malformed", new Object[]{bindPort});
                        }
                        while (!MNet.availablePort((int)start)) {
                            ++start;
                            this.scenario.cnt();
                        }
                        bindPort = String.valueOf(start);
                    }
                    ExposedPort tcp = ExposedPort.tcp((int)M.to((Object)MString.afterIndex((String)port, (char)':'), (int)0));
                    Ports.Binding bind = Ports.Binding.bindPort((int)M.to((Object)bindPort, (int)0));
                    PortBinding ports3 = new PortBinding(bind, tcp);
                    this.exposedPorts.add(tcp);
                    this.portConfig.add(ports3);
                    continue;
                }
                ExposedPort tcp = ExposedPort.tcp((int)M.to((Object)port, (int)0));
                ports = new PortBinding(Ports.Binding.empty(), tcp);
                this.exposedPorts.add(tcp);
                this.portConfig.add(ports);
            }
            System.out.println("--- Port Binding: " + this.portConfig);
            this.hostBuilder.withPortBindings(this.portConfig);
        }
        if (this.entrypoint.size() > 0) {
            this.builder.withEntrypoint(this.entrypoint);
        }
        if (this.volumes.size() > 0) {
            for (String vol : this.volumes) {
                AccessMode mode = AccessMode.DEFAULT;
                String src = MString.beforeIndex((String)vol, (char)':');
                String trg = MString.afterIndex((String)vol, (char)':');
                if (MString.isIndex((String)trg, (char)':')) {
                    String modeStr = MString.afterIndex((String)trg, (char)':');
                    trg = MString.beforeIndex((String)trg, (char)':');
                    if (modeStr.equals("ro")) {
                        mode = AccessMode.ro;
                    }
                    if (modeStr.equals("rw")) {
                        mode = AccessMode.rw;
                    }
                }
                Volume v = new Volume(trg);
                this.volumesDef.add(v);
                this.volumesBind.add(new Bind(src, v, mode));
            }
            this.builder.withVolumes(this.volumesDef);
            this.hostBuilder.withBinds(this.volumesBind);
        }
        if (this.env.size() > 0) {
            this.builder.withEnv(this.env);
        }
        if (this.cmd.size() > 0) {
            this.builder.withCmd(this.cmd);
        }
        if (this.links.size() > 0) {
            for (String link : this.links) {
                this.linksBind.add(new Link(MString.beforeIndex((String)link, (char)':'), MString.afterIndex((String)link, (char)':')));
            }
            this.hostBuilder.withLinks(this.linksBind);
        }
        this.builder.withHostConfig(this.hostBuilder);
        this.builder.withExposedPorts(this.exposedPorts);
    }
}

