/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.tests;

import ch.qos.logback.classic.Level;
import de.mhus.lib.core.MApi;
import de.mhus.lib.core.MXml;
import de.mhus.lib.core.cfg.CfgProvider;
import de.mhus.lib.core.cfg.NodeCfgProvider;
import de.mhus.lib.core.logging.Log;
import de.mhus.lib.core.node.INode;
import de.mhus.lib.core.node.MNode;
import de.mhus.lib.core.util.MUri;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.logging.Handler;
import javax.xml.parsers.ParserConfigurationException;
import org.junit.jupiter.api.TestInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class TestUtil {
    public static void configureApacheCommonLogging(String logger, java.util.logging.Level level) {
        try {
            System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
            System.setProperty("org.apache.commons.logging.simplelog.showdatetime", "true");
            String l = TestUtil.javaToApacheLogLevel(level);
            if (logger == null) {
                System.setProperty("org.apache.commons.logging", l);
                System.out.println("Logging set default: " + l);
                java.util.logging.Logger root = (java.util.logging.Logger)LoggerFactory.getLogger((String)"ROOT");
                root.setLevel(java.util.logging.Level.INFO);
                return;
            }
            System.setProperty("org.apache.commons.logging." + logger, l);
            System.out.println("Logging set: " + logger + "=" + l);
            Logger logger2 = LoggerFactory.getLogger((String)logger);
            ch.qos.logback.classic.Logger logger3 = (ch.qos.logback.classic.Logger)logger2;
            logger3.setLevel(Level.toLevel((String)l));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static String javaToApacheLogLevel(java.util.logging.Level level) {
        String l = "FATAL";
        switch (level.getName()) {
            case "INFO": {
                l = "INFO";
                break;
            }
            case "WARNING": {
                l = "WARN";
                break;
            }
            case "FINE": {
                l = "DEBUG";
                break;
            }
            case "FINER": {
                l = "TRACE";
                break;
            }
            case "SEVERE": {
                l = "WARN";
            }
        }
        return l;
    }

    public static void configureJavaLogger(String name, java.util.logging.Level level) {
        java.util.logging.Logger logger = java.util.logging.Logger.getLogger(name);
        logger.setLevel(level);
    }

    public static void configureJavaLogger(java.util.logging.Level level) {
        System.setProperty("java.util.logging.SimpleFormatter.format", "%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS.%1$tL %4$-7s [%3$s] (%2$s) %5$s %6$s%n");
        java.util.logging.Logger rootLogger = java.util.logging.Logger.getLogger("");
        for (Handler handler : rootLogger.getHandlers()) {
            handler.setLevel(level);
        }
        rootLogger.setLevel(level);
    }

    public static void enableDebug() {
        MApi.setDirtyTrace((boolean)false);
        MApi.get().getLogFactory().setDefaultLevel(Log.LEVEL.DEBUG);
    }

    public static String getPluginVersion(String uriStr) {
        MUri uri = MUri.toUri((String)uriStr);
        String[] parts = uri.getPath().split("/");
        return parts[2];
    }

    public static String conrentVersion() throws ParserConfigurationException, SAXException, IOException {
        Document doc = MXml.loadXml((File)new File("pom.xml"));
        String version = MXml.getValue((Element)doc.getDocumentElement(), (String)"/parent/version", (String)"");
        return version;
    }

    public static void start(TestInfo testInfo) {
        if (testInfo == null) {
            System.out.println(">>> unknown");
            return;
        }
        Optional clazz = testInfo.getTestClass();
        Optional method = testInfo.getTestMethod();
        System.out.println(">>> " + (clazz == null || clazz.isEmpty() ? "?" : ((Class)clazz.get()).getCanonicalName()) + "::" + (method == null || method.isEmpty() ? "?" : ((Method)method.get()).getName()));
    }

    public static void stop(TestInfo testInfo) {
        if (testInfo == null) {
            System.out.println("<<< unknown");
            return;
        }
        Optional clazz = testInfo.getTestClass();
        Optional method = testInfo.getTestMethod();
        System.out.println("<<< " + (clazz == null || clazz.isEmpty() ? "?" : ((Class)clazz.get()).getCanonicalName()) + "::" + (method == null || method.isEmpty() ? "?" : ((Method)method.get()).getName()));
    }

    public static void clearCfg() {
        for (CfgProvider p : MApi.get().getCfgManager().getProviders().toArray(new CfgProvider[0])) {
            MApi.get().getCfgManager().unregisterCfgProvider(p.getName());
        }
        MApi.get().getCfgManager().doRestart();
    }

    public static void setCfg(Class<?> owner, String parameter, String value) {
        TestUtil.setCfg(owner.getCanonicalName(), parameter, value);
    }

    public static void setCfg(String owner, String parameter, String value) {
        TestCfgProvider provider = null;
        for (CfgProvider p : MApi.get().getCfgManager().getProviders()) {
            if (!p.getName().equals(owner)) continue;
            provider = p;
        }
        if (provider == null) {
            provider = new TestCfgProvider(owner, (INode)new MNode());
            MApi.get().getCfgManager().registerCfgProvider((CfgProvider)provider);
        }
        if (!(provider instanceof TestCfgProvider)) {
            MApi.get().getCfgManager().unregisterCfgProvider(provider.getName());
            provider = new TestCfgProvider(owner, provider.getConfig());
            MApi.get().getCfgManager().registerCfgProvider((CfgProvider)provider);
        }
        MNode c = (MNode)((TestCfgProvider)provider).getConfig();
        c.setString(parameter, value);
        MApi.get().getCfgManager().doRestart();
    }

    private static class TestCfgProvider
    extends NodeCfgProvider {
        public TestCfgProvider(String name, INode config) {
            super(name);
            this.config = config;
        }

        public void doRestart() {
        }

        public void doStart() {
        }

        public void doStop() {
        }
    }
}

