/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.tests.docker;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.model.Frame;
import de.mhus.lib.core.MCast;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.MThread;
import de.mhus.lib.core.io.PipedStream;
import de.mhus.lib.errors.NotFoundException;
import de.mhus.lib.tests.docker.DockerContainer;
import de.mhus.lib.tests.docker.DockerScenario;
import de.mhus.lib.tests.docker.LogFilter;
import java.io.Closeable;
import java.io.IOException;
import java.util.LinkedList;

public class LogStream
extends ResultCallback.Adapter<Frame> {
    private PipedStream output = new PipedStream();
    private DockerContainer cont;
    private boolean print = true;
    private boolean closed = false;
    private LinkedList<Byte> capture = null;
    private LogFilter filter = null;
    private boolean completed = false;

    public LogStream(DockerScenario scenario, String contName) throws NotFoundException {
        this.cont = scenario.get(contName);
    }

    public LogStream(DockerContainer cont) {
        this.cont = cont;
    }

    public PipedStream getOutput() {
        return this.output;
    }

    public void onStart(Closeable closeable) {
        this.completed = false;
        super.onStart(closeable);
    }

    public void onComplete() {
        this.completed = true;
        super.onComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNext(Frame item) {
        if (this.closed) {
            return;
        }
        try {
            String logStr = null;
            if (this.print || this.capture != null) {
                LinkedList<Byte> sb = new LinkedList<Byte>();
                for (byte b : item.getPayload()) {
                    if (b == 0) continue;
                    sb.add(b);
                    if (this.capture == null) continue;
                    LogStream logStream = this;
                    synchronized (logStream) {
                        this.capture.add(b);
                    }
                }
                logStr = new String(MCast.toByteArray(sb), MString.CHARSET_CHARSET_UTF_8);
            }
            if (this.print) {
                System.out.print(logStr);
            }
            this.output.getOut().write(item.getPayload());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public LinkedList<Byte> readLineRaw() {
        LinkedList<Byte> sb = new LinkedList<Byte>();
        try {
            int c;
            do {
                if ((c = this.output.getIn().read()) < 0) {
                    return sb;
                }
                sb.add((byte)c);
            } while (c != 10);
            return sb;
        }
        catch (IOException e) {
            e.printStackTrace();
            return sb;
        }
    }

    public String readLine() {
        LinkedList<Byte> array = this.readLineRaw();
        array.removeIf(v -> v == 0);
        if (this.filter != null) {
            this.filter.doFilter(array);
        }
        String logStr = new String(MCast.toByteArray(array), MString.CHARSET_CHARSET_UTF_8);
        return logStr;
    }

    public LinkedList<Byte> readAllRaw() {
        LinkedList<Byte> sb = new LinkedList<Byte>();
        try {
            while (true) {
                int av;
                if ((av = this.output.getIn().available()) > 0) {
                    int c = this.output.getIn().read();
                    if (c < 0) {
                        return sb;
                    }
                    sb.add((byte)c);
                    continue;
                }
                MThread.sleep((long)100L);
                if (sb.size() > 0 && (av < 0 || this.closed || this.completed)) break;
            }
            return sb;
        }
        catch (IOException e) {
            e.printStackTrace();
            return sb;
        }
    }

    public String readAll() {
        LinkedList<Byte> array = this.readAllRaw();
        array.removeIf(v -> v == 0);
        if (this.filter != null) {
            this.filter.doFilter(array);
        }
        String logStr = new String(MCast.toByteArray(array), MString.CHARSET_CHARSET_UTF_8);
        return logStr;
    }

    public void close() throws IOException {
        this.closed = true;
        super.close();
        this.output.close();
    }

    public DockerContainer getContainer() {
        return this.cont;
    }

    public boolean isPrint() {
        return this.print;
    }

    public LogStream setPrint(boolean print) {
        this.print = print;
        return this;
    }

    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogStream setCapture(boolean capt) {
        LogStream logStream = this;
        synchronized (logStream) {
            this.capture = capt ? new LinkedList() : null;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCaptured() {
        LogStream logStream = this;
        synchronized (logStream) {
            if (this.capture == null) {
                return null;
            }
            if (this.filter != null) {
                this.filter.doFilter(this.capture);
            }
            return new String(MCast.toByteArray(this.capture), MString.CHARSET_CHARSET_UTF_8);
        }
    }

    public LogFilter getFilter() {
        return this.filter;
    }

    public void setFilter(LogFilter filter) {
        this.filter = filter;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void setCompleted(boolean completed) {
        this.completed = completed;
    }
}

