/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.tests;

import de.mhus.lib.core.MApi;
import de.mhus.lib.core.MXml;
import de.mhus.lib.core.logging.Log;
import de.mhus.lib.core.util.MUri;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Optional;
import javax.xml.parsers.ParserConfigurationException;
import org.junit.jupiter.api.TestInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class TestUtil {
    public static void enableDebug() {
        MApi.setDirtyTrace((boolean)false);
        MApi.get().getLogFactory().setDefaultLevel(Log.LEVEL.DEBUG);
    }

    public static String getPluginVersion(String uriStr) {
        MUri uri = MUri.toUri((String)uriStr);
        String[] parts = uri.getPath().split("/");
        return parts[2];
    }

    public static String conrentVersion() throws ParserConfigurationException, SAXException, IOException {
        Document doc = MXml.loadXml((File)new File("pom.xml"));
        String version = MXml.getValue((Element)doc.getDocumentElement(), (String)"/parent/version", (String)"");
        return version;
    }

    public static void start(TestInfo testInfo) {
        if (testInfo == null) {
            System.out.println(">>> unknown");
            return;
        }
        Optional clazz = testInfo.getTestClass();
        Optional method = testInfo.getTestMethod();
        System.out.println(">>> " + (clazz == null || clazz.isEmpty() ? "?" : ((Class)clazz.get()).getCanonicalName()) + "::" + (method == null || method.isEmpty() ? "?" : ((Method)method.get()).getName()));
    }

    public static void stop(TestInfo testInfo) {
        if (testInfo == null) {
            System.out.println("<<< unknown");
            return;
        }
        Optional clazz = testInfo.getTestClass();
        Optional method = testInfo.getTestMethod();
        System.out.println("<<< " + (clazz == null || clazz.isEmpty() ? "?" : ((Class)clazz.get()).getCanonicalName()) + "::" + (method == null || method.isEmpty() ? "?" : ((Method)method.get()).getName()));
    }
}

