/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.tests;

import de.mhus.lib.core.MCast;
import de.mhus.lib.core.MStopWatch;
import de.mhus.lib.tests.SkipTestException;
import de.mhus.lib.tests.TestUtil;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Optional;
import java.util.Scanner;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;

public class TestCase {
    private MStopWatch timer;
    protected boolean skipTest = false;
    private static PrintStream out;
    private static PrintStream err;
    private static InputStream in;
    protected static boolean waitBeforeExecute;

    @BeforeAll
    public static void beforeAll(TestInfo testInfo) {
        System.out.println();
        Optional clazz = testInfo.getTestClass();
        if (clazz.isPresent()) {
            System.out.println("START TEST FOR " + ((Class)clazz.get()).getCanonicalName());
        } else {
            System.out.println("START TEST FOR UNKNOWN");
        }
        out = System.out;
        err = System.err;
        in = System.in;
        if (MCast.toboolean((Object)System.getenv().getOrDefault("test.waitBeforeExecute", ""), (boolean)false)) {
            waitBeforeExecute = true;
        }
    }

    @BeforeEach
    public void beforeEach(TestInfo testInfo) throws SkipTestException {
        if (out != null) {
            System.setOut(out);
        }
        if (err != null) {
            System.setErr(err);
        }
        if (in != null) {
            System.setIn(in);
        }
        if (this.skipTest) {
            throw new SkipTestException();
        }
        System.out.println();
        System.out.println("--------------------------------------------------");
        TestUtil.start(testInfo);
        System.out.println("--------------------------------------------------");
        if (waitBeforeExecute) {
            System.out.println("Press ENTER to start test");
            Scanner scanner = new Scanner(System.in);
            scanner.nextLine();
            scanner.close();
        }
        this.timer = new MStopWatch().start();
    }

    @AfterEach
    public void afterEach(TestInfo testInfo) {
        this.timer.stop();
        if (out != null) {
            System.setOut(out);
        }
        if (err != null) {
            System.setErr(err);
        }
        if (in != null) {
            System.setIn(in);
        }
        System.out.println();
        System.out.println("--------------------------------------------------");
        TestUtil.stop(testInfo);
        System.out.println("Time: " + this.timer.getCurrentTimeAsString());
        System.out.println("--------------------------------------------------");
    }

    static {
        waitBeforeExecute = false;
    }
}

