/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.servlet.security;

import de.mhus.lib.core.MLog;
import de.mhus.lib.core.cfg.CfgLong;
import de.mhus.lib.core.util.LongValue;
import de.mhus.lib.servlet.security.SecurityApi;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DefaultSecurityWatch
extends MLog
implements SecurityApi {
    private static CfgLong CFG_MAX_PER_SEC = new CfgLong(SecurityApi.class, "maxHitsPerSecond", 1000L);
    private static CfgLong CFG_MAX_IPS = new CfgLong(SecurityApi.class, "maxIPsPerSecond", 1000L);
    private HashMap<String, LongValue> hits = new HashMap();
    long lastSec = 0L;

    @Override
    public synchronized boolean checkHttpRequest(HttpServletRequest req, HttpServletResponse res) {
        long h;
        long sec = System.currentTimeMillis() / 1000L;
        if (this.lastSec != sec) {
            this.hits.clear();
            this.lastSec = sec;
        }
        if ((long)this.hits.size() > (Long)CFG_MAX_IPS.value()) {
            this.log().t("Blocked MAX IPS", new Object[0]);
            return false;
        }
        String ip = req.getRemoteAddr();
        LongValue hit = this.hits.get(ip);
        if (hit == null) {
            hit = new LongValue(0L);
            this.hits.put(ip, hit);
        }
        if ((h = hit.get()) > (Long)CFG_MAX_PER_SEC.value()) {
            this.log().t("Blocked IP", new Object[]{ip});
            return false;
        }
        hit.set(h + 1L);
        return true;
    }
}

