/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.errors;

import de.mhus.lib.basics.IResult;
import de.mhus.lib.basics.RC;

public class MRuntimeException
extends RuntimeException
implements IResult {
    private static final long serialVersionUID = 1L;
    private int rc;

    public MRuntimeException(RC.STATUS rc, Object ... in) {
        this(RC.CAUSE.ENCAPSULATE, rc.rc(), rc.name(), in);
    }

    public MRuntimeException(RC.CAUSE causeHandling, RC.STATUS rc, Object ... in) {
        this(causeHandling, rc.rc(), rc.name(), in);
    }

    public MRuntimeException(int rc, Throwable cause) {
        this(RC.CAUSE.ENCAPSULATE, rc, cause.getMessage(), cause);
    }

    public MRuntimeException(IResult cause) {
        super(cause.getMessage(), cause instanceof Throwable ? (Throwable)((Object)cause) : null);
        this.setReturnCode(cause.getReturnCode());
    }

    public MRuntimeException(IResult cause, String msg, Object ... parameters) {
        super(RC.toMessage(cause.getReturnCode(), cause, msg, parameters, 0), cause instanceof Throwable ? (Throwable)((Object)cause) : null);
        this.setReturnCode(cause.getReturnCode());
    }

    public MRuntimeException(int rc, String msg, Object ... in) {
        this(RC.CAUSE.ENCAPSULATE, rc, msg, in);
    }

    public MRuntimeException(RC.CAUSE causeHandling, int rc, String msg, Object ... parameters) {
        super(RC.toMessage(rc, causeHandling, msg, parameters, 0), RC.findCause(causeHandling, parameters));
        this.setReturnCode(RC.findReturnCode(causeHandling, rc, parameters));
    }

    public MRuntimeException(int rc) {
        super(RC.toString(rc));
        this.setReturnCode(rc);
    }

    @Override
    public String toString() {
        return this.getReturnCode() + " " + super.toString();
    }

    @Override
    public int getReturnCode() {
        return this.rc;
    }

    private void setReturnCode(int rc) {
        this.rc = rc;
    }
}

