/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.basics;

import de.mhus.lib.basics.IResult;
import java.io.Serializable;
import java.util.Arrays;

public class RC {
    public static final int WARNING_TEMPORARILY = 199;
    public static final int OK = 200;
    public static final int CREATED = 201;
    public static final int ACCEPTED = 202;
    public static final int WARNING = 299;
    public static final int ERROR = 400;
    public static final int ACCESS_DENIED = 401;
    public static final int FORBIDDEN = 403;
    public static final int NOT_FOUND = 404;
    public static final int CONFLICT = 409;
    public static final int GONE = 410;
    public static final int TOO_LARGE = 413;
    public static final int SYNTAX_ERROR = 415;
    public static final int USAGE = 422;
    public static final int LIMIT = 427;
    public static final int TEAPOT = 418;
    public static final int INTERNAL_ERROR = 500;
    public static final int NOT_SUPPORTED = 501;
    public static final int BUSY = 503;
    public static final int TIMEOUT = 504;
    public static final int TOO_DEEP = 508;
    public static final int RANGE_MIN_SUCCESSFUL = 200;
    public static final int RANGE_MAX_SUCCESSFUL = 299;
    public static final int RANGE_MIN_PROFESSIONAL = 400;
    public static final int RANGE_MAX_PROFESSIONAL = 499;
    public static final int RANGE_MIN_TECHNICAL = 500;
    public static final int RANGE_MAX_TECHNICAL = 599;
    public static final int RANGE_MIN_CUSTOM = 900;
    public static final int RANGE_MAX_CUSTOM = 999;
    public static final int RANGE_MAX = 999;

    public static String toMessage(int rc, IResult cause, String msg, Object[] parameters, int maxSize) {
        return RC.toMessage(rc, CAUSE.IGNORE, msg, parameters, maxSize, cause);
    }

    public static String toMessage(int rc, CAUSE causeHandling, String msg, Object[] parameters, int maxSize) {
        return RC.toMessage(rc, causeHandling, msg, parameters, maxSize, null);
    }

    public static String toMessage(int rc, CAUSE causeHandling, String msg, Object[] parameters, int maxSize, IResult cause) {
        if (causeHandling == null) {
            causeHandling = CAUSE.ENCAPSULATE;
        }
        if (msg == null && parameters == null) {
            return "[" + (Serializable)(rc >= 0 ? Integer.valueOf(rc) : "") + "]";
        }
        if (parameters == null && msg.indexOf(34) == -1) {
            return "[" + (String)(rc >= 0 ? rc + "," : "") + "\"" + msg + "\"]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        if (rc >= 0) {
            sb.append(rc).append(",");
        }
        RC.addEncoded(sb, msg, maxSize);
        boolean isCause = false;
        if (parameters != null && parameters.length > 0) {
            int beforeLen;
            String msg2;
            boolean firstException = true;
            IResult appendCause = null;
            for (Object parameter : parameters) {
                sb.append(",");
                if (RC.truncateMessage(sb, maxSize)) {
                    return sb.toString();
                }
                if (parameter != null) {
                    if (parameter instanceof IResult && causeHandling == CAUSE.ADAPT) {
                        Object m = ((IResult)parameter).getMessage();
                        if (m != null && maxSize > 0 && ((String)m).length() > maxSize) {
                            m = ((String)m).substring(0, maxSize) + "...\"]";
                        }
                        return m;
                    }
                    if (parameter instanceof IResult && causeHandling == CAUSE.APPEND) {
                        appendCause = (IResult)parameter;
                        firstException = false;
                        sb.setLength(sb.length() - 1);
                        continue;
                    }
                    if (parameter instanceof Throwable && causeHandling != CAUSE.IGNORE && firstException) {
                        firstException = false;
                        sb.setLength(sb.length() - 1);
                        continue;
                    }
                    if (parameter instanceof Object[]) {
                        RC.addEncoded(sb, Arrays.deepToString((Object[])parameter), maxSize);
                        continue;
                    }
                    if (parameter instanceof int[]) {
                        RC.addEncoded(sb, Arrays.toString((int[])parameter), maxSize);
                        continue;
                    }
                    if (parameter instanceof double[]) {
                        RC.addEncoded(sb, Arrays.toString((double[])parameter), maxSize);
                        continue;
                    }
                    if (parameter instanceof long[]) {
                        RC.addEncoded(sb, Arrays.toString((long[])parameter), maxSize);
                        continue;
                    }
                    if (parameter instanceof byte[]) {
                        RC.addEncoded(sb, Arrays.toString((byte[])parameter), maxSize);
                        continue;
                    }
                    if (parameter instanceof float[]) {
                        RC.addEncoded(sb, Arrays.toString((float[])parameter), maxSize);
                        continue;
                    }
                    if (parameter instanceof short[]) {
                        RC.addEncoded(sb, Arrays.toString((short[])parameter), maxSize);
                        continue;
                    }
                    if (parameter instanceof char[]) {
                        RC.addEncoded(sb, Arrays.toString((char[])parameter), maxSize);
                        continue;
                    }
                    RC.addEncoded(sb, parameter, maxSize);
                    continue;
                }
                sb.append("null");
            }
            if (appendCause != null && (msg2 = appendCause.getMessage()) != null) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                beforeLen = sb.length();
                if (msg2.startsWith("[") && msg2.endsWith("]")) {
                    sb.append(msg2);
                } else {
                    RC.addEncoded(sb, msg2, maxSize);
                }
                if (maxSize > 0 && sb.length() > maxSize) {
                    sb.setLength(beforeLen);
                    sb.append("[" + appendCause.getReturnCode() + ",\"...cause...\"]");
                }
                isCause = true;
            }
            if (cause != null && (msg2 = cause.getMessage()) != null) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                beforeLen = sb.length();
                if (msg2.startsWith("[") && msg2.endsWith("]")) {
                    sb.append(msg2);
                } else {
                    RC.addEncoded(sb, msg2, maxSize);
                }
                if (maxSize > 0 && sb.length() > maxSize) {
                    sb.setLength(beforeLen);
                    sb.append("[" + cause.getReturnCode() + ",\"...cause...\"]");
                }
                isCause = true;
            }
        }
        if (isCause || !RC.truncateMessage(sb, maxSize)) {
            sb.append("]");
        }
        return sb.toString();
    }

    private static boolean truncateMessage(StringBuilder sb, int maxSize) {
        if (maxSize > 0) {
            if (sb.length() == maxSize) {
                if (maxSize < 3) {
                    sb.append("\"...\"]");
                    return true;
                }
                char c1 = sb.charAt(maxSize - 1);
                char c2 = sb.charAt(maxSize - 2);
                if (c1 == '\"' && c2 != ',' && c2 != '\\') {
                    sb.append(",\"...\"]");
                } else if (c1 == '\\' && c2 != '\\') {
                    sb.append("\\...\"]");
                } else {
                    sb.append("\"...\"]");
                }
                return true;
            }
            if (sb.length() > maxSize) {
                sb.setLength(maxSize);
                if (maxSize < 3) {
                    sb.append("...\"]");
                    return true;
                }
                char c1 = sb.charAt(maxSize - 1);
                char c2 = sb.charAt(maxSize - 2);
                if (c1 == '\"' && c2 != ',' && c2 != '\\') {
                    sb.append(",\"...\"]");
                } else if (c1 == '\\' && c2 != '\\') {
                    sb.append("\\...\"]");
                } else {
                    sb.append("...\"]");
                }
                return true;
            }
        }
        return false;
    }

    private static void addEncoded(StringBuilder sb, Object obj, int maxSize) {
        int nextPos;
        if (obj == null) {
            sb.append("null");
            return;
        }
        if (maxSize > 0 && sb.length() > maxSize) {
            return;
        }
        String msg = String.valueOf(obj);
        int pos = 0;
        sb.append("\"");
        while ((nextPos = msg.indexOf(34, pos)) != -1) {
            RC.encodeBackslash(sb, msg.substring(pos, nextPos), maxSize);
            sb.append("\\\"");
            pos = nextPos + 1;
            if (maxSize > 0 && sb.length() > maxSize) {
                return;
            }
            if (pos < msg.length()) continue;
        }
        if (pos < msg.length()) {
            RC.encodeBackslash(sb, msg.substring(pos), maxSize);
        }
        sb.append("\"");
    }

    private static void encodeBackslash(StringBuilder sb, String msg, int maxSize) {
        int nextPos;
        if (maxSize > 0 && sb.length() > maxSize) {
            return;
        }
        int pos = 0;
        while ((nextPos = msg.indexOf(92, pos)) != -1) {
            sb.append(msg.substring(pos, nextPos));
            sb.append("\\\\");
            pos = nextPos + 1;
            if (pos >= msg.length()) break;
            if (pos >= msg.length()) continue;
            sb.append(msg.substring(pos));
        }
        if (pos < msg.length()) {
            sb.append(msg.substring(pos));
        }
    }

    public static Throwable findCause(CAUSE causeHandling, Object ... in) {
        if (in == null || causeHandling != null && causeHandling == CAUSE.HIDE) {
            return null;
        }
        for (Object o : in) {
            if (!(o instanceof Throwable)) continue;
            return (Throwable)o;
        }
        return null;
    }

    public static int findReturnCode(CAUSE causeHandling, int rc, Object ... in) {
        if (causeHandling == null || in == null || causeHandling != CAUSE.ADAPT && causeHandling != CAUSE.APPEND) {
            return rc;
        }
        for (Object o : in) {
            if (!(o instanceof IResult)) continue;
            return ((IResult)o).getReturnCode();
        }
        return rc;
    }

    public static int normalize(int rc) {
        if (rc < 0) {
            return 400;
        }
        if (rc >= 1000) {
            return 400;
        }
        return rc;
    }

    public static boolean isWarning(int rc) {
        return rc == 0 || rc == 299 || rc == 199;
    }

    public static boolean isTechnicalError(int rc) {
        return rc >= 500 && rc <= 599;
    }

    public static boolean isProfessionalError(int rc) {
        return rc < 0 || rc >= 400 && rc <= 499 || rc > 400;
    }

    public static boolean isSuccessful(int rc) {
        return rc >= 0 && rc <= 299;
    }

    public static boolean canRetry(int rc) {
        return rc >= 500 && rc <= 599 && rc != 501;
    }

    public static String toString(int rc) {
        switch (rc) {
            case 199: {
                return "WARNING_TEMPORARILY";
            }
            case 200: {
                return "OK";
            }
            case 201: {
                return "CREATED";
            }
            case 202: {
                return "ACCEPTED";
            }
            case 299: {
                return "WARNING";
            }
            case 400: {
                return "ERROR";
            }
            case 401: {
                return "ACCESS_DENIED";
            }
            case 403: {
                return "FORBIDDEN";
            }
            case 404: {
                return "NOT_FOUND";
            }
            case 410: {
                return "GONE";
            }
            case 413: {
                return "TOO_LARGE";
            }
            case 415: {
                return "SYNTAX_ERROR";
            }
            case 422: {
                return "USAGE";
            }
            case 418: {
                return "TEAPOT";
            }
            case 500: {
                return "INTERNAL_ERROR";
            }
            case 501: {
                return "NOT_SUPPORTED";
            }
            case 503: {
                return "BUSY";
            }
            case 504: {
                return "TIMEOUT";
            }
            case 508: {
                return "TOO_DEEP";
            }
            case 409: {
                return "CONFLICT";
            }
            case 427: {
                return "LIMIT";
            }
        }
        return String.valueOf(rc);
    }

    public static enum STATUS {
        WARNING_TEMPORARILY(199),
        OK(200),
        CREATED(201),
        ACCEPTED(202),
        WARNING(299),
        ERROR(400),
        ACCESS_DENIED(401),
        FORBIDDEN(403),
        NOT_FOUND(404),
        CONFLICT(409),
        GONE(410),
        TOO_LARGE(413),
        SYNTAX_ERROR(415),
        TEAPOT(418),
        USAGE(422),
        LIMIT(427),
        INTERNAL_ERROR(500),
        NOT_SUPPORTED(501),
        BUSY(503),
        TIMEOUT(504),
        TOO_DEEP(508);

        private final int rc;

        private STATUS(int rc) {
            this.rc = rc;
        }

        public int rc() {
            return this.rc;
        }
    }

    public static enum CAUSE {
        ENCAPSULATE,
        ADAPT,
        APPEND,
        IGNORE,
        HIDE;

    }
}

