/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.resource.reference;

import java.io.File;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class ResourceReference {
    public static final String ANY_TYPE = "any";
    public static final String STRING = "string";
    public static final String FILE = "file";
    public static final String MEMORY = "memory";
    public static final String CLASSPATH = "classpath";
    private final String type;
    private final String path;

    public static ResourceReference inline(String template) {
        return new ResourceReference(STRING, template);
    }

    public static ResourceReference memory(String name) {
        return new ResourceReference(MEMORY, name);
    }

    public static ResourceReference file(String path) {
        return new ResourceReference(FILE, path);
    }

    public static ResourceReference file(File path) {
        return new ResourceReference(FILE, path.getAbsolutePath());
    }

    public static ResourceReference classpath(String path) {
        return new ResourceReference(CLASSPATH, path);
    }

    public ResourceReference(String type, String path) {
        this.type = type;
        this.path = path;
    }

    public String getType() {
        return this.type;
    }

    public String getPath() {
        return this.path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceReference that = (ResourceReference)o;
        return new EqualsBuilder().append(this.type, that.type).append(this.path, that.path).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.type).append(this.path).toHashCode();
    }

    public String toString() {
        if (ANY_TYPE.equals(this.type)) {
            return this.path;
        }
        return String.format("%s:%s", this.type, this.path);
    }
}

