/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.parser.cache;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.SettableFuture;
import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import org.jtwig.environment.Environment;
import org.jtwig.model.tree.Node;
import org.jtwig.parser.JtwigParser;
import org.jtwig.parser.cache.RetrieveFuture;
import org.jtwig.parser.cache.TemplateCache;
import org.jtwig.resource.reference.ResourceReference;

public class InMemoryConcurrentPersistentTemplateCache
implements TemplateCache {
    private final ConcurrentMap<ResourceReference, Future<Result>> cache;
    private final Function<Future<Result>, Result> retriever = new RetrieveFuture<Result>();

    public InMemoryConcurrentPersistentTemplateCache() {
        this(101, Integer.MAX_VALUE);
    }

    public InMemoryConcurrentPersistentTemplateCache(int initialCapacity, int maxValue) {
        this.cache = new ConcurrentLinkedHashMap.Builder().initialCapacity(initialCapacity).maximumWeightedCapacity(maxValue).build();
    }

    @Override
    public Node get(JtwigParser parser, Environment environment, ResourceReference resource) {
        Optional optional = Optional.fromNullable(this.cache.get(resource));
        if (optional.isPresent()) {
            return this.retriever.apply((Future<Result>)optional.get()).get();
        }
        SettableFuture<Result> future = SettableFuture.create();
        Future result = this.cache.putIfAbsent(resource, future);
        if (result == null) {
            try {
                Node node = parser.parse(environment, resource);
                future.set(new Result(Optional.of(node), Optional.absent()));
                return node;
            }
            catch (RuntimeException e) {
                this.cache.remove(resource);
                future.set(new Result(Optional.absent(), Optional.of(e)));
                throw e;
            }
        }
        return this.retriever.apply(result).get();
    }

    public static class Result {
        private final Optional<Node> node;
        private final Optional<RuntimeException> exception;

        public Result(Optional<Node> node, Optional<RuntimeException> exception) {
            this.node = node;
            this.exception = exception;
        }

        public Node get() {
            if (!this.node.isPresent()) {
                throw this.exception.get();
            }
            return this.node.get();
        }
    }
}

