/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.constgenerator;

import de.mhus.lib.basics.consts.GenerateConst;
import de.mhus.lib.basics.consts.GenerateHidden;
import de.mhus.lib.basics.consts.Identifier;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.xbean.finder.ClassFinder;
import org.jtwig.JtwigModel;
import org.jtwig.JtwigTemplate;

@Mojo(name="const-generate", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, inheritByDefault=false)
public class ConstGeneratorMojo
extends AbstractMojo {
    private HashSet<String> ignoreList = new HashSet();
    @Parameter(defaultValue="${project}")
    protected MavenProject project;
    @Parameter
    protected String outputDirectory;
    @Parameter(defaultValue="project")
    protected String classLoader;
    @Parameter(defaultValue=".*")
    protected String artifactInclude;
    @Parameter
    protected boolean debug;
    @Parameter
    protected boolean force;
    @Parameter
    protected String prefix;
    @Parameter
    protected String ignore;
    @Parameter
    protected String template;
    private URLClassLoader loader;

    public ConstGeneratorMojo() {
        this.ignoreList.add("EQUALS");
        this.ignoreList.add("CLASS");
        this.ignoreList.add("CLONE");
        this.ignoreList.add("WAIT");
        this.ignoreList.add("FINALIZE");
        this.ignoreList.add("HASH_CODE");
        this.ignoreList.add("NOTIFY");
        this.ignoreList.add("NOTIFY_ALL");
        this.ignoreList.add("WRITE_EXTERNAL");
        this.ignoreList.add("READ_EXTERNAL");
        this.ignoreList.add("TO_STRING");
        this.ignoreList.add("");
        this.debug = false;
        this.force = false;
        this.prefix = "_";
        this.ignore = null;
        this.template = null;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        File templateFile;
        if ("true".equals(System.getenv("maven.generate.force"))) {
            this.force = true;
        }
        if (this.ignore != null) {
            for (String i : this.ignore.split(",")) {
                this.ignoreList.add(i.toUpperCase());
            }
        }
        if (this.template == null) {
            try {
                this.template = this.project.getBuild().getOutputDirectory() + "/template.twig";
                templateFile = new File(this.template);
                if (this.force || !templateFile.exists()) {
                    int b;
                    InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/template.twig");
                    FileOutputStream os = new FileOutputStream(this.template);
                    while ((b = is.read()) >= 0) {
                        os.write(b);
                    }
                    is.close();
                    os.close();
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException(this.template, e);
            }
        }
        templateFile = new File(this.template);
        JtwigTemplate jtwigTemplate = JtwigTemplate.fileTemplate(templateFile);
        try {
            ClassFinder finder = this.createFinder(this.classLoader);
            List classes = finder.findAnnotatedClasses(GenerateConst.class);
            for (Class clazz : classes) {
                HashMap<String, String> constFields;
                File constFile;
                File classSource;
                block19: {
                    URL classUrl = clazz.getClassLoader().getResource(clazz.getName().replace('.', '/') + ".class");
                    if (classUrl == null || clazz.getName() == null || clazz.getCanonicalName().indexOf(36) > -1) {
                        if (!this.debug) continue;
                        this.getLog().info((CharSequence)("Ignoring non main class " + classUrl));
                        continue;
                    }
                    classSource = this.findClassSourceFile(clazz);
                    if (classSource == null) {
                        if (!this.debug) continue;
                        this.getLog().info((CharSequence)("Ignoring, source not found " + classUrl));
                        continue;
                    }
                    String constClassName = clazz.getPackage().getName() + "." + this.prefix + clazz.getSimpleName();
                    constFile = null;
                    constFile = this.outputDirectory != null ? new File(this.outputDirectory + File.separatorChar + constClassName.replace('.', File.separatorChar) + ".java") : new File(classSource.getParentFile(), this.prefix + clazz.getSimpleName() + ".java");
                    constFields = new HashMap<String, String>();
                    try {
                        Field[] fields;
                        Class<?> constClass = this.loader.loadClass(constClassName);
                        for (Field f : fields = constClass.getDeclaredFields()) {
                            if (!Modifier.isStatic(f.getModifiers())) continue;
                            String value = ((Identifier)f.get(null)).toString();
                            constFields.put(f.getName(), value);
                        }
                    }
                    catch (ClassNotFoundException e) {
                        if (!this.debug) break block19;
                        this.getLog().warn((CharSequence)constClassName, (Throwable)e);
                    }
                }
                if (this.debug) {
                    this.getLog().info((CharSequence)("Found " + classSource));
                    this.getLog().info((CharSequence)("   To: " + constFile));
                }
                Map<String, String> fields = this.analyzeClass(clazz);
                if (!this.force && this.compareList(constFields.keySet(), fields.keySet()) && this.compareList(constFields.values(), fields.values())) {
                    if (!this.debug) continue;
                    this.getLog().info((CharSequence)"not changed");
                    continue;
                }
                this.getLog().info((CharSequence)("Write " + constFile));
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("constPackage", clazz.getPackage().getName());
                parameters.put("constName", this.prefix + clazz.getSimpleName());
                parameters.put("constClass", clazz.getPackage().getName() + "." + this.prefix + clazz.getSimpleName());
                parameters.put("baseName", clazz.getSimpleName());
                parameters.put("baseClass", clazz.getCanonicalName());
                parameters.put("basePackage", clazz.getPackage().getName());
                parameters.put("fields", fields);
                JtwigModel jtwigModel = JtwigModel.newModel(parameters);
                File dir = constFile.getParentFile();
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                FileOutputStream fos = new FileOutputStream(constFile);
                jtwigTemplate.render(jtwigModel, fos);
                fos.close();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private boolean compareList(Collection<String> set1, Collection<String> set2) {
        if (set1.size() != set2.size()) {
            if (this.debug) {
                this.getLog().info((CharSequence)"--- different size");
                this.getLog().info((CharSequence)("--- 1: " + set1));
                this.getLog().info((CharSequence)("--- 2: " + set2));
            }
            return false;
        }
        for (String key : set1) {
            if (set2.contains(key)) continue;
            if (this.debug) {
                this.getLog().info((CharSequence)("--- key not found " + key));
                this.getLog().info((CharSequence)("--- 1: " + set1));
                this.getLog().info((CharSequence)("--- 2: " + set2));
            }
            return false;
        }
        return true;
    }

    private Map<String, String> analyzeClass(Class<?> clazz) {
        String orgName;
        String name;
        GenerateConst config = clazz.getAnnotation(GenerateConst.class);
        TreeMap<String, String> out = new TreeMap<String, String>();
        for (Field field : this.findFields(clazz)) {
            name = field.getName();
            if (name.contains("$") || name.equals("")) continue;
            orgName = name;
            name = this.toName(field.getName());
            if (this.ignore(config, name) || field.getAnnotation(GenerateHidden.class) != null) continue;
            if (config.restricted() || Modifier.isPublic(field.getModifiers())) {
                out.put("FIELD_" + name, orgName);
            }
            if (!this.hasAnnotation(config, field.getAnnotations())) continue;
            out.put("_" + name, orgName);
        }
        for (Method meth : this.findMethods(clazz)) {
            name = meth.getName();
            if (name.contains("$")) continue;
            if (name.startsWith("get") || name.startsWith("set")) {
                name = name.substring(3);
            } else if (name.startsWith("is")) {
                name = name.substring(2);
            }
            orgName = name;
            if (this.ignore(config, name = this.toName(name)) || meth.getAnnotation(GenerateHidden.class) != null) continue;
            if (config.restricted() || Modifier.isPublic(meth.getModifiers())) {
                out.put("METHOD_" + this.toName(meth.getName()), meth.getName());
            }
            if (!this.hasAnnotation(config, meth.getAnnotations())) continue;
            out.put("_" + name, orgName);
        }
        out.put("CLASS_NAME", clazz.getName());
        out.put("CLASS_PATH", clazz.getCanonicalName());
        out.put("CLASS_EXTENDS", clazz.getSuperclass().getCanonicalName());
        out.put("PROJECT_VERSION", this.project.getVersion());
        out.put("PROJECT_ARTIFACT", this.project.getArtifactId());
        out.put("PROJECT_GROUP", this.project.getGroupId());
        out.put("PROJECT_DESCRIPTION", this.project.getDescription());
        return out;
    }

    private boolean hasAnnotation(GenerateConst config, Annotation[] annotations) {
        if (config == null || config.annotation().length == 0) {
            return true;
        }
        for (Class<? extends Annotation> a1 : config.annotation()) {
            for (Annotation a2 : annotations) {
                if (!a1.getCanonicalName().equals(a2.annotationType().getCanonicalName())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean ignore(GenerateConst config, String name) {
        if (name.length() == 0) {
            return true;
        }
        if (this.ignoreList.contains(name = name.toUpperCase())) {
            return true;
        }
        for (String item : config.ignore()) {
            if (!name.equals(item.toUpperCase())) continue;
            return true;
        }
        return false;
    }

    private List<Method> findMethods(Class<?> clazz) {
        LinkedList<Method> list = new LinkedList<Method>();
        this.findMethods(list, clazz);
        return list;
    }

    private void findMethods(LinkedList<Method> list, Class<?> clazz) {
        if (clazz == null) {
            return;
        }
        for (Method m : clazz.getDeclaredMethods()) {
            list.add(m);
        }
        this.findMethods(list, clazz.getSuperclass());
    }

    private List<Field> findFields(Class<?> clazz) {
        LinkedList<Field> list = new LinkedList<Field>();
        this.findFields(list, clazz);
        return list;
    }

    private void findFields(List<Field> list, Class<?> clazz) {
        if (clazz == null) {
            return;
        }
        for (Field f : clazz.getDeclaredFields()) {
            list.add(f);
        }
        this.findFields(list, clazz.getSuperclass());
    }

    private String toName(String name) {
        StringBuilder out = new StringBuilder();
        boolean lastUpper = false;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            boolean isUpper = Character.isUpperCase(c);
            if (i != 0 && isUpper && !lastUpper) {
                out.append('_');
            }
            lastUpper = isUpper;
            c = Character.toUpperCase(c);
            out.append(c);
        }
        return out.toString();
    }

    private File findClassSourceFile(Class<?> clazz) {
        String cp = clazz.getCanonicalName().replace('.', File.separatorChar);
        if (cp.endsWith(".class")) {
            cp = cp.substring(0, cp.length() - 6);
        }
        cp = cp + ".java";
        for (String source : this.project.getCompileSourceRoots()) {
            File f = new File(source + File.separatorChar + cp);
            if (!f.exists() || !f.isFile()) continue;
            return f;
        }
        return null;
    }

    private ClassFinder createFinder(String classloaderType) throws Exception {
        ClassFinder finder;
        if ("project".equals(classloaderType)) {
            ArrayList<URL> urls = new ArrayList<URL>();
            urls.add(new File(this.project.getBuild().getOutputDirectory()).toURI().toURL());
            for (Artifact artifact : this.project.getArtifacts()) {
                if (this.artifactInclude != null && this.artifactInclude.length() > 0 && artifact.getArtifactId().matches(this.artifactInclude)) {
                    File file = artifact.getFile();
                    if (file == null) continue;
                    this.getLog().debug((CharSequence)("Use artifact " + artifact.getArtifactId() + ": " + file));
                    urls.add(file.toURI().toURL());
                    continue;
                }
                this.getLog().debug((CharSequence)("Ignore artifact " + artifact.getArtifactId()));
            }
            this.loader = new URLClassLoader(urls.toArray(new URL[urls.size()]), ((Object)((Object)this)).getClass().getClassLoader());
            finder = new ClassFinder((ClassLoader)this.loader, urls);
        } else if ("plugin".equals(this.classLoader)) {
            finder = new ClassFinder(((Object)((Object)this)).getClass().getClassLoader());
        } else {
            throw new MojoFailureException("classLoader attribute must be 'project' or 'plugin'");
        }
        return finder;
    }
}

