/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.render.expression.calculator;

import com.google.common.base.Optional;
import java.util.List;
import org.jtwig.exceptions.CalculationException;
import org.jtwig.model.expression.ComprehensionListExpression;
import org.jtwig.render.RenderRequest;
import org.jtwig.render.expression.CalculateExpressionService;
import org.jtwig.render.expression.calculator.ExpressionCalculator;
import org.jtwig.render.expression.calculator.enumerated.EnumerationListStrategy;
import org.jtwig.util.ErrorMessageFormatter;

public class ComprehensionListExpressionCalculator
implements ExpressionCalculator<ComprehensionListExpression> {
    @Override
    public Object calculate(RenderRequest request, ComprehensionListExpression expression) {
        Object endValue;
        Object startValue;
        CalculateExpressionService calculateExpressionService = request.getEnvironment().getRenderEnvironment().getCalculateExpressionService();
        EnumerationListStrategy listEnumerationStrategy = request.getEnvironment().getListEnumerationStrategy();
        Optional<List<Object>> result = listEnumerationStrategy.enumerate(request, startValue = calculateExpressionService.calculate(request, expression.getStart()), endValue = calculateExpressionService.calculate(request, expression.getEnd()));
        if (result.isPresent()) {
            return result.get();
        }
        throw new CalculationException(ErrorMessageFormatter.errorMessage(expression.getPosition(), String.format("Unable to calculate a list from a comprehension list starting with '%s' and ending with '%s'", startValue, endValue)));
    }
}

