/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.parser.parboiled;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jtwig.parser.addon.AddonParserProvider;
import org.jtwig.parser.config.JtwigParserConfiguration;
import org.jtwig.parser.config.SyntaxConfiguration;
import org.jtwig.parser.parboiled.DocumentParser;
import org.jtwig.parser.parboiled.base.BasicParser;
import org.jtwig.parser.parboiled.base.BooleanParser;
import org.jtwig.parser.parboiled.base.LexicParser;
import org.jtwig.parser.parboiled.base.LimitsParser;
import org.jtwig.parser.parboiled.base.PositionTrackerParser;
import org.jtwig.parser.parboiled.base.SpacingParser;
import org.jtwig.parser.parboiled.expression.AnyExpressionParser;
import org.jtwig.parser.parboiled.expression.BinaryOperationExpressionParser;
import org.jtwig.parser.parboiled.expression.BinaryOperationSuffixExpressionParser;
import org.jtwig.parser.parboiled.expression.BinaryOrPrimaryExpressionParser;
import org.jtwig.parser.parboiled.expression.BooleanExpressionParser;
import org.jtwig.parser.parboiled.expression.ComprehensionListExpressionParser;
import org.jtwig.parser.parboiled.expression.ConstantExpressionParser;
import org.jtwig.parser.parboiled.expression.EnumerationListExpressionParser;
import org.jtwig.parser.parboiled.expression.FunctionExpressionParser;
import org.jtwig.parser.parboiled.expression.MapExpressionParser;
import org.jtwig.parser.parboiled.expression.MapSelectionExpressionParser;
import org.jtwig.parser.parboiled.expression.NullExpressionParser;
import org.jtwig.parser.parboiled.expression.NumberExpressionParser;
import org.jtwig.parser.parboiled.expression.PrimaryExpressionParser;
import org.jtwig.parser.parboiled.expression.SimpleExpressionParser;
import org.jtwig.parser.parboiled.expression.StringExpressionParser;
import org.jtwig.parser.parboiled.expression.TernaryOperationExpressionParser;
import org.jtwig.parser.parboiled.expression.TestOperationExpressionParser;
import org.jtwig.parser.parboiled.expression.UnaryOperationExpressionParser;
import org.jtwig.parser.parboiled.expression.VariableExpressionParser;
import org.jtwig.parser.parboiled.expression.operator.BinaryOperatorParser;
import org.jtwig.parser.parboiled.expression.operator.UnaryOperatorParser;
import org.jtwig.parser.parboiled.expression.test.AnyTestExpressionParser;
import org.jtwig.parser.parboiled.expression.test.TestExpressionParser;
import org.jtwig.parser.parboiled.node.AutoEscapeNodeParser;
import org.jtwig.parser.parboiled.node.BlockNodeParser;
import org.jtwig.parser.parboiled.node.CommentParser;
import org.jtwig.parser.parboiled.node.CompositeNodeParser;
import org.jtwig.parser.parboiled.node.ContentEscapeNodeParser;
import org.jtwig.parser.parboiled.node.DoNodeParser;
import org.jtwig.parser.parboiled.node.EmbedNodeParser;
import org.jtwig.parser.parboiled.node.ExtendsNodeParser;
import org.jtwig.parser.parboiled.node.FilterNodeParser;
import org.jtwig.parser.parboiled.node.FlushNodeParser;
import org.jtwig.parser.parboiled.node.ForLoopNodeParser;
import org.jtwig.parser.parboiled.node.IfNodeParser;
import org.jtwig.parser.parboiled.node.ImportNodeParser;
import org.jtwig.parser.parboiled.node.ImportSelfNodeParser;
import org.jtwig.parser.parboiled.node.IncludeNodeParser;
import org.jtwig.parser.parboiled.node.MacroNodeParser;
import org.jtwig.parser.parboiled.node.OutputNodeParser;
import org.jtwig.parser.parboiled.node.OverrideBlockNodeParser;
import org.jtwig.parser.parboiled.node.SetNodeParser;
import org.jtwig.parser.parboiled.node.TextNodeParser;
import org.jtwig.parser.parboiled.node.VerbatimNodeParser;
import org.jtwig.render.expression.calculator.operation.binary.BinaryOperator;
import org.jtwig.render.expression.calculator.operation.unary.UnaryOperator;
import org.jtwig.resource.reference.ResourceReference;
import org.parboiled.BaseParser;
import org.parboiled.Parboiled;

public class ParserContext {
    private final ResourceReference resource;
    private final JtwigParserConfiguration configuration;
    private final Map<Class, BaseParser> parsers;
    private final Collection<AddonParserProvider> addOnParsers;

    public static ParserContext instance(ResourceReference resource, JtwigParserConfiguration configuration, Collection<AddonParserProvider> addOnParsers, Collection<UnaryOperator> unaryOperators, Collection<BinaryOperator> binaryOperators, List<Class<? extends TestExpressionParser>> testExpressionParsers) {
        ParserContext context = new ParserContext(resource, configuration, addOnParsers);
        Parboiled.createParser(BooleanParser.class, context);
        Parboiled.createParser(PositionTrackerParser.class, context);
        Parboiled.createParser(SpacingParser.class, context);
        Parboiled.createParser(LexicParser.class, context, ParserContext.extraKeywords(addOnParsers));
        Parboiled.createParser(LimitsParser.class, context);
        Parboiled.createParser(CommentParser.class, context);
        for (Class<? extends TestExpressionParser> testExpressionParser : testExpressionParsers) {
            Parboiled.createParser(testExpressionParser, context);
        }
        Parboiled.createParser(AnyTestExpressionParser.class, context, testExpressionParsers);
        Parboiled.createParser(MapSelectionExpressionParser.class, context);
        Parboiled.createParser(UnaryOperatorParser.class, context, unaryOperators);
        Parboiled.createParser(BinaryOperatorParser.class, context);
        Parboiled.createParser(BinaryOrPrimaryExpressionParser.class, context);
        Parboiled.createParser(EnumerationListExpressionParser.class, context);
        Parboiled.createParser(ComprehensionListExpressionParser.class, context);
        Parboiled.createParser(MapExpressionParser.class, context);
        Parboiled.createParser(StringExpressionParser.class, context);
        Parboiled.createParser(NumberExpressionParser.class, context);
        Parboiled.createParser(BooleanExpressionParser.class, context);
        Parboiled.createParser(NullExpressionParser.class, context);
        Parboiled.createParser(ConstantExpressionParser.class, context);
        Parboiled.createParser(VariableExpressionParser.class, context);
        Parboiled.createParser(FunctionExpressionParser.class, context);
        Parboiled.createParser(TestOperationExpressionParser.class, context);
        Parboiled.createParser(UnaryOperationExpressionParser.class, context);
        Parboiled.createParser(BinaryOperationExpressionParser.class, context);
        Parboiled.createParser(BinaryOperationSuffixExpressionParser.class, context, binaryOperators);
        Parboiled.createParser(TernaryOperationExpressionParser.class, context);
        Parboiled.createParser(PrimaryExpressionParser.class, context);
        Parboiled.createParser(SimpleExpressionParser.class, context);
        Parboiled.createParser(AnyExpressionParser.class, context);
        Parboiled.createParser(SetNodeParser.class, context);
        Parboiled.createParser(DoNodeParser.class, context);
        Parboiled.createParser(FlushNodeParser.class, context);
        Parboiled.createParser(IncludeNodeParser.class, context);
        Parboiled.createParser(BlockNodeParser.class, context);
        Parboiled.createParser(OverrideBlockNodeParser.class, context);
        Parboiled.createParser(IfNodeParser.class, context);
        Parboiled.createParser(ForLoopNodeParser.class, context);
        Parboiled.createParser(ImportSelfNodeParser.class, context);
        Parboiled.createParser(ImportNodeParser.class, context);
        Parboiled.createParser(TextNodeParser.class, context);
        Parboiled.createParser(MacroNodeParser.class, context);
        Parboiled.createParser(ExtendsNodeParser.class, context);
        Parboiled.createParser(EmbedNodeParser.class, context);
        Parboiled.createParser(OutputNodeParser.class, context);
        Parboiled.createParser(AutoEscapeNodeParser.class, context);
        Parboiled.createParser(ContentEscapeNodeParser.class, context);
        Parboiled.createParser(VerbatimNodeParser.class, context);
        Parboiled.createParser(FilterNodeParser.class, context);
        for (AddonParserProvider provider : addOnParsers) {
            Parboiled.createParser(provider.parser(), context);
        }
        Parboiled.createParser(CompositeNodeParser.class, context);
        Parboiled.createParser(DocumentParser.class, context);
        return context;
    }

    private static Collection<String> extraKeywords(Collection<AddonParserProvider> addOnParsers) {
        ArrayList<String> result = new ArrayList<String>();
        for (AddonParserProvider provider : addOnParsers) {
            result.addAll(provider.keywords());
        }
        return result;
    }

    public ParserContext(ResourceReference resource, JtwigParserConfiguration configuration, Collection<AddonParserProvider> addOnParsers) {
        this.resource = resource;
        this.configuration = configuration;
        this.parsers = new HashMap<Class, BaseParser>();
        this.addOnParsers = addOnParsers;
    }

    public <T extends BaseParser> ParserContext register(Class type, T parser) {
        this.parsers.put(type, parser);
        return this;
    }

    public Collection<AddonParserProvider> getAddOnParsers() {
        return this.addOnParsers;
    }

    public <T extends BasicParser> T parser(Class<T> type) {
        return (T)((BasicParser)this.parsers.get(type));
    }

    public SyntaxConfiguration syntaxConfiguration() {
        return this.configuration.getSyntaxConfiguration();
    }

    public JtwigParserConfiguration getConfiguration() {
        return this.configuration;
    }

    public ResourceReference resource() {
        return this.resource;
    }
}

