/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.parser.parboiled;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jtwig.environment.Environment;
import org.jtwig.model.tree.Node;
import org.jtwig.parser.JtwigParser;
import org.jtwig.parser.ParseException;
import org.jtwig.parser.config.JtwigParserConfiguration;
import org.jtwig.parser.parboiled.DocumentParser;
import org.jtwig.parser.parboiled.ParserContext;
import org.jtwig.parser.util.ParboiledExceptionMessageExtractor;
import org.jtwig.resource.ResourceService;
import org.jtwig.resource.metadata.ResourceMetadata;
import org.jtwig.resource.reference.ResourceReference;
import org.parboiled.common.FileUtils;
import org.parboiled.errors.ParseError;
import org.parboiled.errors.ParserRuntimeException;
import org.parboiled.parserunners.BasicParseRunner;
import org.parboiled.support.ParsingResult;

public class ParboiledJtwigParser
implements JtwigParser {
    private final ParboiledExceptionMessageExtractor exceptionMessageExtractor = new ParboiledExceptionMessageExtractor();
    private final JtwigParserConfiguration configuration;

    public ParboiledJtwigParser(JtwigParserConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public Node parse(Environment environment, ResourceReference resource) {
        ResourceService resourceService = environment.getResourceEnvironment().getResourceService();
        BasicParseRunner runner = new BasicParseRunner(ParserContext.instance(resource, this.configuration, this.configuration.getAddonParserProviders(), this.configuration.getUnaryOperators(), this.configuration.getBinaryOperators(), this.configuration.getTestExpressionParsers()).parser(DocumentParser.class).NodeRule());
        try {
            ResourceMetadata resourceMetadata = resourceService.loadMetadata(resource);
            Charset charset = resourceMetadata.getCharset().or(environment.getResourceEnvironment().getDefaultInputCharset());
            ParsingResult result = runner.run(FileUtils.readAllText(resourceMetadata.load(), charset));
            if (result.hasErrors()) {
                throw new ParseException(this.toMessage(result.parseErrors));
            }
            if (!result.matched) {
                throw new ParseException("Invalid template format");
            }
            return (Node)result.valueStack.pop();
        }
        catch (ParserRuntimeException e) {
            if (e.getCause() != null && e.getCause() instanceof ParseException) {
                ParseException cause = (ParseException)e.getCause();
                throw new ParseException(String.format("%s\n%s", cause.getMessage(), this.exceptionMessageExtractor.extract(e)), cause.getCause());
            }
            throw new ParseException(e);
        }
    }

    private String toMessage(List<ParseError> parseErrors) {
        return StringUtils.join(Collections2.transform(parseErrors, new Function<ParseError, String>(){

            @Override
            public String apply(ParseError input) {
                return String.format("%d, %d -> %s", input.getStartIndex(), input.getEndIndex(), input.getErrorMessage());
            }
        }), "\n");
    }
}

